/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.reservoir;

import cats.Invariant$;
import cats.Monad;
import cats.data.Chain;
import cats.data.IndexedReaderWriterStateT;
import com.kotori316.fluidtank.contents.DefaultTransferEnv$;
import com.kotori316.fluidtank.contents.FluidTransferLog;
import com.kotori316.fluidtank.contents.GenericAmount;
import com.kotori316.fluidtank.contents.Tank;
import com.kotori316.fluidtank.contents.TransferEnv;
import com.kotori316.fluidtank.fluids.FluidAmountUtil$;
import com.kotori316.fluidtank.fluids.FluidLike;
import com.kotori316.fluidtank.fluids.PlatformFluidAccess;
import com.kotori316.fluidtank.fluids.VanillaPotion;
import com.kotori316.fluidtank.potions.PotionFluidHandler;
import com.kotori316.fluidtank.reservoir.ItemReservoir;
import net.minecraft.world.item.ItemStack;
import scala.MatchError;
import scala.Tuple3;

public final class ReservoirPotionFluidHandler
implements PotionFluidHandler {
    private final ItemReservoir itemReservoir;
    private final ItemStack stack;

    public ReservoirPotionFluidHandler(ItemReservoir itemReservoir, ItemStack stack) {
        this.itemReservoir = itemReservoir;
        this.stack = stack;
    }

    private Tank<FluidLike> getTank() {
        return this.itemReservoir.getTank(this.stack);
    }

    @Override
    public PlatformFluidAccess.TransferStack fill(GenericAmount<FluidLike> toFill, VanillaPotion vanillaPotion) {
        return this.move(toFill, this.getTank().fillOp());
    }

    @Override
    public PlatformFluidAccess.TransferStack drain(GenericAmount<FluidLike> toDrain, VanillaPotion vanillaPotion) {
        return this.move(toDrain, this.getTank().drainOp());
    }

    private PlatformFluidAccess.TransferStack move(GenericAmount<FluidLike> source, IndexedReaderWriterStateT<Object, TransferEnv, Chain<FluidTransferLog>, GenericAmount<FluidLike>, GenericAmount<FluidLike>, Tank<FluidLike>> op) {
        Tuple3 tuple3 = (Tuple3)op.run((Object)DefaultTransferEnv$.MODULE$, source, (Monad)Invariant$.MODULE$.catsInstancesForId());
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        Tuple3 $1$ = tuple3;
        Tuple3 tuple32 = $1$;
        GenericAmount rest = (GenericAmount)tuple32._2();
        Tank newTank = (Tank)tuple32._3();
        GenericAmount<FluidLike> moved = source.operatorMinus(rest);
        if (moved.isEmpty()) {
            return new PlatformFluidAccess.TransferStack(FluidAmountUtil$.MODULE$.EMPTY(), this.stack, false);
        }
        ItemStack copy = this.stack.copy();
        this.itemReservoir.saveTank(copy, newTank);
        return new PlatformFluidAccess.TransferStack(moved, copy);
    }

    @Override
    public GenericAmount<FluidLike> getContent() {
        return this.getTank().content();
    }

    @Override
    public boolean isValidHandler() {
        GenericAmount<FluidLike> content = this.getContent();
        return content.content() instanceof VanillaPotion || content.isEmpty();
    }
}

