/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.tank;

import cats.implicits$;
import com.kotori316.fluidtank.FluidTankCommon;
import com.kotori316.fluidtank.MCImplicits$;
import com.kotori316.fluidtank.fluids.PlatformFluidAccess;
import com.kotori316.fluidtank.fluids.TransferFluid;
import com.kotori316.fluidtank.fluids.TransferFluid$;
import com.kotori316.fluidtank.item.PlatformItemAccess;
import com.kotori316.fluidtank.tank.ItemBlockTank;
import com.kotori316.fluidtank.tank.PlatformTankAccess;
import com.kotori316.fluidtank.tank.TankPos;
import com.kotori316.fluidtank.tank.Tier;
import com.kotori316.fluidtank.tank.TileTank;
import com.mojang.serialization.MapCodec;
import java.io.Serializable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import scala.Function1;

public abstract class BlockTank
extends Block
implements EntityBlock {
    private final Tier tier;
    private final ItemBlockTank itemBlock;
    private final MapCodec<BlockTank> codec;

    public BlockTank(Tier tier) {
        this.tier = tier;
        super(BlockBehaviour.Properties.of().strength(1.0f).dynamicShape().pushReaction(PushReaction.BLOCK).forceSolidOn().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"fluidtank", (String)tier.getBlockName()))));
        this.registerDefaultState((BlockState)this.getStateDefinition().any().setValue(TankPos.TANK_POS_PROPERTY, (Comparable)TankPos.SINGLE));
        this.itemBlock = this.createTankItem();
        this.codec = BlockBehaviour.simpleCodec(_$5 -> this.createBlockInstance());
    }

    public Tier tier() {
        return this.tier;
    }

    public final ItemBlockTank itemBlock() {
        return this.itemBlock;
    }

    public ItemBlockTank createTankItem() {
        return new ItemBlockTank(this);
    }

    public abstract BlockTank createBlockInstance();

    public final MapCodec<BlockTank> codec() {
        return this.codec;
    }

    public final Item asItem() {
        return this.itemBlock();
    }

    public String toString() {
        return "Block{" + this.tier().getBlockName() + "}";
    }

    public abstract BlockEntity newBlockEntity(BlockPos var1, BlockState var2);

    public final boolean skipRendering(BlockState state, BlockState adjacentBlockState, Direction side) {
        return true;
    }

    public InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos pos, Player player, BlockHitResult blockHitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TileTank) {
            TileTank tileTank;
            TileTank tank = tileTank = (TileTank)blockEntity;
            if (!level.isClientSide()) {
                player.displayClientMessage(tank.getConnection().getTextComponent(), true);
            }
            return InteractionResult.SUCCESS;
        }
        BlockEntity tile = blockEntity;
        FluidTankCommon.LOGGER.error(FluidTankCommon.MARKER_TANK, "There is not TileTank at {}, but {} in {}", new Object[]{implicits$.MODULE$.toShow((Object)pos, MCImplicits$.MODULE$.showPos()).show(), tile, "useWithoutItem"});
        return super.useWithoutItem(blockState, level, pos, player, blockHitResult);
    }

    public InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Object object;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TileTank) {
            TileTank tileTank;
            TileTank tank = tileTank = (TileTank)blockEntity;
            object = !(stack.getItem() instanceof ItemBlockTank) ? (PlatformFluidAccess.getInstance().isFluidContainer(stack) ? (!level.isClientSide() ? (Record)TransferFluid$.MODULE$.transferFluid(tank.getConnection(), stack, player, hand).map((Function1 & Serializable)r -> {
                TransferFluid$.MODULE$.setItem(player, hand, (TransferFluid.Result)r, pos);
                return InteractionResult.SUCCESS_SERVER;
            }).getOrElse(BlockTank::useItemOn$$anonfun$2) : InteractionResult.SUCCESS_SERVER) : InteractionResult.TRY_WITH_EMPTY_HAND) : InteractionResult.PASS;
        } else {
            BlockEntity tile = blockEntity;
            FluidTankCommon.LOGGER.error(FluidTankCommon.MARKER_TANK, "There is not TileTank at {}, but {} in {}", new Object[]{implicits$.MODULE$.toShow((Object)pos, MCImplicits$.MODULE$.showPos()).show(), tile, "useItemOn"});
            object = InteractionResult.PASS;
        }
        return (InteractionResult)object;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        super.setPlacedBy(level, pos, state, entity, stack);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TileTank) {
            TileTank tileTank;
            TileTank tank = tileTank = (TileTank)blockEntity;
            if (!level.isClientSide()) {
                tank.onBlockPlacedBy();
                return;
            }
            return;
        }
        BlockEntity tile = blockEntity;
        FluidTankCommon.LOGGER.error(FluidTankCommon.MARKER_TANK, "There is not TileTank at {}, but {} in {}", new Object[]{implicits$.MODULE$.toShow((Object)pos, MCImplicits$.MODULE$.showPos()).show(), tile, "setPlacedBy"});
    }

    public final boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public final int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos, Direction direction) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TileTank) {
            TileTank tileTank;
            TileTank tileTank2 = tileTank = (TileTank)blockEntity;
            return tileTank2.getComparatorLevel();
        }
        BlockEntity tile = blockEntity;
        FluidTankCommon.LOGGER.error(FluidTankCommon.MARKER_TANK, "There is not TileTank at {}, but {} in {}", new Object[]{implicits$.MODULE$.toShow((Object)pos, MCImplicits$.MODULE$.showPos()).show(), tile, "getAnalogOutputSignal"});
        return 0;
    }

    public void saveTankNBT(BlockEntity tileEntity, ItemStack stack, HolderLookup.Provider provider) {
        BlockEntity blockEntity = tileEntity;
        if (blockEntity instanceof TileTank) {
            TileTank tileTank = (TileTank)blockEntity;
            TileTank tank = tileTank;
            if (!tank.getTank().isEmpty()) {
                TagValueOutput valueOutput = TagValueOutput.createWithContext((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)provider);
                tank.saveWithId((ValueOutput)valueOutput);
                PlatformItemAccess.setTileTag(stack, valueOutput, tank.getType());
            }
            if (tank.hasCustomName()) {
                stack.set(DataComponents.CUSTOM_NAME, (Object)tank.getCustomName());
                return;
            }
            return;
        }
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean includeData) {
        ItemStack stack = super.getCloneItemStack(level, pos, state, includeData);
        this.saveTankNBT(level.getBlockEntity(pos), stack, (HolderLookup.Provider)level.registryAccess());
        return stack;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return FluidTankCommon.TANK_SHAPE;
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{TankPos.TANK_POS_PROPERTY});
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.isClientSide()) {
            return super.getTicker(level, state, blockEntityType);
        }
        if (PlatformTankAccess.isTankType(blockEntityType)) {
            return (_$6, _$7, _$8, tile) -> ((TileTank)tile).onTickLoading();
        }
        return null;
    }

    private static final Record useItemOn$$anonfun$2() {
        return InteractionResult.PASS;
    }
}

