/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.tank;

import com.kotori316.fluidtank.contents.GenericAccess;
import com.kotori316.fluidtank.contents.GenericAmount;
import com.kotori316.fluidtank.contents.GenericUnit$;
import com.kotori316.fluidtank.fluids.FluidAmountUtil$;
import com.kotori316.fluidtank.fluids.FluidLike;
import com.kotori316.fluidtank.fluids.PlatformFluidAccess;
import com.kotori316.fluidtank.tank.BlockTank;
import java.util.function.Consumer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.component.TypedEntityData;
import net.minecraft.world.level.block.Block;
import scala.math.BigInt;
import scala.runtime.BoxesRunTime;

public class ItemBlockTank
extends BlockItem {
    private final BlockTank blockTank;

    public ItemBlockTank(BlockTank blockTank) {
        this.blockTank = blockTank;
        super((Block)blockTank, new Item.Properties().useBlockDescriptionPrefix().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"fluidtank", (String)blockTank.tier().getBlockName()))));
    }

    public BlockTank blockTank() {
        return this.blockTank;
    }

    public String toString() {
        return this.blockTank().tier().getBlockName();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltip, TooltipFlag isAdvanced) {
        super.appendHoverText(stack, context, tooltipDisplay, tooltip, isAdvanced);
        TypedEntityData component = (TypedEntityData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (component != null) {
            CompoundTag nbt = component.copyTagWithoutId();
            CompoundTag tankTag = nbt.getCompoundOrEmpty("tank");
            GenericAccess<FluidLike> access = FluidAmountUtil$.MODULE$.access();
            GenericAmount<FluidLike> fluid = access.read(tankTag.getCompoundOrEmpty("content"));
            BigInt capacity = GenericUnit$.MODULE$.fromByteArray(tankTag.getByteArray("amount_generic").orElse(new byte[0]));
            tooltip.accept((Component)Component.translatable((String)"fluidtank.waila.short", (Object[])new Object[]{PlatformFluidAccess.getInstance().getDisplayName(fluid), BoxesRunTime.boxToLong((long)GenericUnit$.MODULE$.asDisplay$extension(fluid.amount())), BoxesRunTime.boxToLong((long)GenericUnit$.MODULE$.asDisplay$extension(capacity))}));
            return;
        }
        tooltip.accept((Component)Component.translatable((String)"fluidtank.waila.capacity", (Object[])new Object[]{GenericUnit$.MODULE$.asForgeFromBigInt(this.blockTank().tier().getCapacity())}));
    }
}

