/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.tank;

import com.kotori316.fluidtank.tank.ItemBlockTank;
import com.kotori316.fluidtank.tank.PlatformTankAccess;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public final class TankLootFunction
extends LootItemConditionalFunction {
    public static final String NAME = "content_tank";
    public static final MapCodec<TankLootFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> LootItemConditionalFunction.commonFields((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, TankLootFunction::new));

    public TankLootFunction(List<LootItemCondition> conditions) {
        super(conditions);
    }

    protected ItemStack run(ItemStack stack, LootContext context) {
        BlockEntity tile = (BlockEntity)context.getParameter(LootContextParams.BLOCK_ENTITY);
        Item item = stack.getItem();
        if (item instanceof ItemBlockTank) {
            ItemBlockTank tank = (ItemBlockTank)item;
            tank.blockTank().saveTankNBT(tile, stack, (HolderLookup.Provider)context.getLevel().registryAccess());
        }
        return stack;
    }

    public LootItemFunctionType<TankLootFunction> getType() {
        return PlatformTankAccess.getInstance().getTankLoot();
    }

    public static LootItemConditionalFunction.Builder<?> builder() {
        return LootItemConditionalFunction.simpleBuilder(TankLootFunction::new);
    }
}

