/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.tank;

import com.google.common.base.CaseFormat;
import com.kotori316.fluidtank.config.PlatformConfigAccess;
import com.kotori316.fluidtank.contents.GenericUnit;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import scala.math.BigInt;

public enum Tier {
    INVALID(0, ""),
    WOOD(1),
    STONE(2),
    IRON(3),
    GOLD(4),
    DIAMOND(5),
    EMERALD(6),
    STAR(7),
    CREATIVE(10, "creative"),
    VOID(0),
    COPPER(2),
    TIN(2),
    BRONZE(3),
    LEAD(3),
    SILVER(3);

    private final int rank;
    private final String blockName;
    private final String name;

    private Tier(int rank, String blockName) {
        this.rank = rank;
        this.blockName = blockName;
        this.name = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
    }

    private Tier(int rank) {
        this.rank = rank;
        this.blockName = "tank_" + this.name().toLowerCase(Locale.ROOT);
        this.name = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
    }

    public BigInt getCapacity() {
        scala.collection.immutable.Map<Tier, BigInt> capacityMap = PlatformConfigAccess.getInstance().getConfig().capacityMap();
        return (BigInt)capacityMap.get((Object)this).getOrElse(() -> {
            throw new IllegalStateException("No capacity for %s".formatted(new Object[]{this}));
        });
    }

    public int getRank() {
        return this.rank;
    }

    public String getBlockName() {
        return this.blockName;
    }

    public boolean isNormalTankTier() {
        return this.getRank() != 0 && this != CREATIVE;
    }

    public String toString() {
        return this.name;
    }

    public static Tier valueOfIgnoreCase(String name) {
        return Tier.valueOf(name.toUpperCase(Locale.ROOT));
    }

    static BigInt fromForge(long forgeAmount) {
        return GenericUnit.asBigIntFromForge(forgeAmount);
    }

    @NotNull
    public static EnumMap<Tier, BigInt> getDefaultCapacityMap() {
        return new EnumMap<Tier, BigInt>(Map.ofEntries(Map.entry(INVALID, Tier.fromForge(0L)), Map.entry(WOOD, Tier.fromForge(4000L)), Map.entry(STONE, Tier.fromForge(16000L)), Map.entry(IRON, Tier.fromForge(256000L)), Map.entry(GOLD, Tier.fromForge(4096000L)), Map.entry(DIAMOND, Tier.fromForge(0xFA0000L)), Map.entry(EMERALD, Tier.fromForge(65536000L)), Map.entry(STAR, Tier.fromForge(1048576000L)), Map.entry(CREATIVE, GenericUnit.CREATIVE_TANK()), Map.entry(VOID, Tier.fromForge(0L)), Map.entry(COPPER, Tier.fromForge(40000L)), Map.entry(TIN, Tier.fromForge(48000L)), Map.entry(BRONZE, Tier.fromForge(256000L)), Map.entry(LEAD, Tier.fromForge(192000L)), Map.entry(SILVER, Tier.fromForge(1024000L))));
    }
}

