/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.fabric;

import com.kotori316.fluidtank.PlatformAccess;
import com.kotori316.fluidtank.PlatformBaseAccess;
import com.kotori316.fluidtank.cat.BlockChestAsTank;
import com.kotori316.fluidtank.contents.GenericAmount;
import com.kotori316.fluidtank.contents.GenericUnit;
import com.kotori316.fluidtank.contents.Tank;
import com.kotori316.fluidtank.fabric.FluidTank;
import com.kotori316.fluidtank.fabric.cat.ChestAsTankStorage;
import com.kotori316.fluidtank.fabric.fluid.FabricConverter;
import com.kotori316.fluidtank.fluids.FluidAmountUtil;
import com.kotori316.fluidtank.fluids.FluidLike;
import com.kotori316.fluidtank.fluids.PlatformFluidAccess;
import com.kotori316.fluidtank.fluids.TransferFluid;
import com.kotori316.fluidtank.fluids.VanillaFluid;
import com.kotori316.fluidtank.fluids.VanillaPotion;
import com.kotori316.fluidtank.potions.PotionFluidHandler;
import com.kotori316.fluidtank.reservoir.ItemReservoir;
import com.kotori316.fluidtank.tank.BlockTank;
import com.kotori316.fluidtank.tank.TankLootFunction;
import com.kotori316.fluidtank.tank.Tier;
import com.kotori316.fluidtank.tank.TileTank;
import com.mojang.serialization.Codec;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.mixin.transfer.BucketItemAccessor;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1755;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5339;
import net.minecraft.class_9331;
import org.apache.logging.log4j.util.Lazy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FabricPlatformAccess
implements PlatformAccess {
    FabricPlatformAccess() {
    }

    @Override
    public boolean isGaseous(class_3611 fluid) {
        return FluidVariantAttributes.isLighterThanAir((FluidVariant)FluidVariant.of((class_3611)fluid));
    }

    @Override
    @NotNull
    public class_3611 getBucketContent(class_1755 bucketItem) {
        return ((BucketItemAccessor)bucketItem).fabric_getFluid();
    }

    @Override
    @NotNull
    public GenericAmount<FluidLike> getFluidContained(class_1799 stack) {
        Iterator iterator;
        PotionFluidHandler potionHandler = PotionFluidHandler.apply(stack);
        if (potionHandler.isValidHandler()) {
            return potionHandler.getContent();
        }
        Storage storage = (Storage)FluidStorage.ITEM.find(stack, (Object)ContainerItemContext.withConstant((class_1799)stack));
        if (storage != null && (iterator = storage.iterator()).hasNext()) {
            StorageView view = (StorageView)iterator.next();
            FluidVariant variant = (FluidVariant)view.getResource();
            long amount = view.getAmount();
            return FluidAmountUtil.from((FluidLike)FluidLike.of(variant.getFluid()), GenericUnit.fromFabric(amount), variant.getComponents());
        }
        return FluidAmountUtil.EMPTY();
    }

    @Override
    public boolean isFluidContainer(class_1799 stack) {
        if (PotionFluidHandler.apply(stack).isValidHandler()) {
            return true;
        }
        Storage storage = (Storage)FluidStorage.ITEM.find(stack, (Object)ContainerItemContext.withConstant((class_1799)stack));
        return storage != null;
    }

    @Override
    public class_2561 getDisplayName(GenericAmount<FluidLike> amount) {
        if (amount.content() instanceof VanillaFluid) {
            return FluidVariantAttributes.getName((FluidVariant)FabricConverter.toVariant(amount, class_3612.field_15906));
        }
        FluidLike fluidLike = amount.content();
        if (fluidLike instanceof VanillaPotion) {
            VanillaPotion vanillaPotion = (VanillaPotion)fluidLike;
            return vanillaPotion.getVanillaPotionName(amount.componentPatch());
        }
        throw new AssertionError();
    }

    @Override
    @NotNull
    public PlatformFluidAccess.TransferStack fillItem(GenericAmount<FluidLike> toFill, class_1799 stack, class_1657 player, class_1268 hand, boolean execute) {
        long filled;
        ContainerItemContext context = ContainerItemContext.ofPlayerHand((class_1657)player, (class_1268)hand);
        FluidLike fluidLike = toFill.content();
        if (fluidLike instanceof VanillaPotion) {
            VanillaPotion vanillaPotion = (VanillaPotion)fluidLike;
            PotionFluidHandler potionHandler = PotionFluidHandler.apply(stack);
            PlatformFluidAccess.TransferStack result = potionHandler.fill(toFill, vanillaPotion);
            return FabricPlatformAccess.moveItem(stack, player, execute, result, context);
        }
        Storage storage = (Storage)FluidStorage.ITEM.find(stack, (Object)context);
        if (storage == null) {
            return new PlatformFluidAccess.TransferStack(FluidAmountUtil.EMPTY(), stack, false);
        }
        try (Transaction transaction = Transaction.openOuter();){
            filled = storage.insert((Object)FabricConverter.toVariant(toFill, class_3612.field_15906), FabricConverter.fabricAmount(toFill), (TransactionContext)transaction);
            if (execute && TransferFluid.shouldMoveItem(player)) {
                transaction.commit();
            }
        }
        return new PlatformFluidAccess.TransferStack(toFill.setAmount(GenericUnit.fromFabric(filled)), context.getItemVariant().toStack((int)context.getAmount()), false);
    }

    @Override
    @NotNull
    public PlatformFluidAccess.TransferStack drainItem(GenericAmount<FluidLike> toDrain, class_1799 stack, class_1657 player, class_1268 hand, boolean execute) {
        long drained;
        ContainerItemContext context = ContainerItemContext.ofPlayerHand((class_1657)player, (class_1268)hand);
        FluidLike fluidLike = toDrain.content();
        if (fluidLike instanceof VanillaPotion) {
            VanillaPotion v = (VanillaPotion)fluidLike;
            PotionFluidHandler potionHandler = PotionFluidHandler.apply(stack);
            PlatformFluidAccess.TransferStack result = potionHandler.drain(toDrain, v);
            return FabricPlatformAccess.moveItem(stack, player, execute, result, context);
        }
        Storage storage = (Storage)FluidStorage.ITEM.find(stack, (Object)context);
        if (storage == null) {
            return new PlatformFluidAccess.TransferStack(FluidAmountUtil.EMPTY(), stack, false);
        }
        try (Transaction transaction = Transaction.openOuter();){
            drained = storage.extract((Object)FabricConverter.toVariant(toDrain, class_3612.field_15906), FabricConverter.fabricAmount(toDrain), (TransactionContext)transaction);
            if (execute && TransferFluid.shouldMoveItem(player)) {
                transaction.commit();
            }
        }
        return new PlatformFluidAccess.TransferStack(toDrain.setAmount(GenericUnit.fromFabric(drained)), context.getItemVariant().toStack((int)context.getAmount()), false);
    }

    @NotNull
    private static PlatformFluidAccess.TransferStack moveItem(class_1799 stack, class_1657 player, boolean execute, PlatformFluidAccess.TransferStack result, ContainerItemContext context) {
        return PlatformFluidAccess.moveItemInTransaction(stack, player, execute, result, Transaction::openOuter, Transaction::commit, (itemStack, transaction) -> context.exchange(ItemVariant.of((class_1799)itemStack), 1L, (TransactionContext)transaction));
    }

    @Override
    @Nullable
    public class_3414 getEmptySound(GenericAmount<FluidLike> fluid) {
        return FluidVariantAttributes.getEmptySound((FluidVariant)FabricConverter.toVariant(fluid, (class_3611)class_3612.field_15910));
    }

    @Override
    @Nullable
    public class_3414 getFillSound(GenericAmount<FluidLike> fluid) {
        return FluidVariantAttributes.getFillSound((FluidVariant)FabricConverter.toVariant(fluid, (class_3611)class_3612.field_15910));
    }

    @Override
    public class_2591<? extends TileTank> getNormalType() {
        return FluidTank.TILE_TANK_TYPE;
    }

    @Override
    public class_2591<? extends TileTank> getCreativeType() {
        return FluidTank.TILE_CREATIVE_TANK_TYPE;
    }

    @Override
    public class_2591<? extends TileTank> getVoidType() {
        return FluidTank.TILE_VOID_TANK_TYPE;
    }

    @Override
    public class_5339<TankLootFunction> getTankLoot() {
        return FluidTank.TANK_LOOT_FUNCTION;
    }

    @Override
    public Map<Tier, Supplier<? extends BlockTank>> getTankBlockMap() {
        return Stream.concat(FluidTank.TANK_MAP.entrySet().stream(), Stream.of(Map.entry(Tier.CREATIVE, FluidTank.BLOCK_CREATIVE_TANK), Map.entry(Tier.VOID, FluidTank.BLOCK_VOID_TANK))).collect(Collectors.toMap(Map.Entry::getKey, e -> e::getValue));
    }

    @Override
    public Map<Tier, ? extends Supplier<? extends ItemReservoir>> getReservoirMap() {
        return FluidTank.RESERVOIR_MAP.entrySet().stream().map(e -> Map.entry((Tier)((Object)((Object)e.getKey())), Lazy.value((Object)((Object)((ItemReservoir)((Object)((Object)e.getValue()))))))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    @NotNull
    public class_1799 getCraftingRemainingItem(class_1799 stack) {
        return stack.getRecipeRemainder();
    }

    @Override
    public Codec<class_1856> ingredientCodec() {
        return class_1856.field_46095;
    }

    @Override
    public class_9331<Tank<FluidLike>> fluidTankComponentType() {
        return FluidTank.FLUID_TANK_DATA_COMPONENT;
    }

    @Override
    public Supplier<? extends BlockChestAsTank> getCATBlock() {
        return Lazy.value((Object)((Object)FluidTank.BLOCK_CAT));
    }

    @Override
    @Nullable
    public class_2586 createCATEntity(class_2338 pos, class_2680 state) {
        return null;
    }

    @Override
    @NotNull
    public List<GenericAmount<FluidLike>> getCATFluids(class_1937 level, class_2338 pos) {
        return ChestAsTankStorage.getCATFluids(level, pos);
    }

    @Override
    @NotNull
    public PlatformBaseAccess.Platforms getPlatform() {
        return PlatformBaseAccess.Platforms.FABRIC;
    }
}

