/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.fabric;

import com.kotori316.fluidtank.DebugLogging;
import com.kotori316.fluidtank.FluidTankCommon;
import com.kotori316.fluidtank.PlatformAccess;
import com.kotori316.fluidtank.cat.BlockChestAsTank;
import com.kotori316.fluidtank.cat.ItemChestAsTank;
import com.kotori316.fluidtank.config.PlatformConfigAccess;
import com.kotori316.fluidtank.contents.Tank;
import com.kotori316.fluidtank.fabric.FabricPlatformAccess;
import com.kotori316.fluidtank.fabric.cat.BlockChestAsTankFabric;
import com.kotori316.fluidtank.fabric.cat.ChestAsTankStorage;
import com.kotori316.fluidtank.fabric.config.FabricPlatformConfigAccess;
import com.kotori316.fluidtank.fabric.message.PacketHandler;
import com.kotori316.fluidtank.fabric.reservoir.ReservoirFluidStorage;
import com.kotori316.fluidtank.fabric.tank.BlockCreativeTankFabric;
import com.kotori316.fluidtank.fabric.tank.BlockTankFabric;
import com.kotori316.fluidtank.fabric.tank.ConnectionStorage;
import com.kotori316.fluidtank.fabric.tank.FabricTankItemStorage;
import com.kotori316.fluidtank.fabric.tank.TileCreativeTankFabric;
import com.kotori316.fluidtank.fabric.tank.TileTankFabric;
import com.kotori316.fluidtank.fluids.FluidAmountUtil;
import com.kotori316.fluidtank.fluids.FluidLike;
import com.kotori316.fluidtank.recipe.TierRecipe;
import com.kotori316.fluidtank.reservoir.ItemReservoir;
import com.kotori316.fluidtank.tank.BlockTank;
import com.kotori316.fluidtank.tank.BlockVoidTank;
import com.kotori316.fluidtank.tank.ItemBlockTank;
import com.kotori316.fluidtank.tank.TankLootFunction;
import com.kotori316.fluidtank.tank.Tier;
import com.kotori316.fluidtank.tank.TileCreativeTank;
import com.kotori316.fluidtank.tank.TileTank;
import com.kotori316.fluidtank.tank.TileVoidTank;
import com.mojang.datafixers.DSL;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_5339;
import net.minecraft.class_7923;
import net.minecraft.class_9331;
import net.minecraft.server.MinecraftServer;

public final class FluidTank
implements ModInitializer {
    public static final Map<Tier, BlockTankFabric> TANK_MAP = Stream.of(Tier.values()).filter(Tier::isNormalTankTier).collect(Collectors.toMap(Function.identity(), BlockTankFabric::new));
    public static final BlockCreativeTankFabric BLOCK_CREATIVE_TANK = new BlockCreativeTankFabric();
    public static final BlockVoidTank BLOCK_VOID_TANK = new BlockVoidTank();
    public static final Map<Tier, ItemBlockTank> TANK_ITEM_MAP = Stream.concat(TANK_MAP.entrySet().stream(), Stream.of(Map.entry(Tier.CREATIVE, BLOCK_CREATIVE_TANK), Map.entry(Tier.VOID, BLOCK_VOID_TANK))).collect(Collectors.toMap(Map.Entry::getKey, e -> ((BlockTank)((Object)((Object)e.getValue()))).itemBlock()));
    public static final class_2591<TileTankFabric> TILE_TANK_TYPE = FabricBlockEntityTypeBuilder.create(TileTankFabric::new, (class_2248[])((class_2248[])TANK_MAP.values().toArray(BlockTank[]::new))).build(DSL.emptyPartType());
    public static final class_2591<TileCreativeTankFabric> TILE_CREATIVE_TANK_TYPE = FabricBlockEntityTypeBuilder.create(TileCreativeTankFabric::new, (class_2248[])new class_2248[]{BLOCK_CREATIVE_TANK}).build(DSL.emptyPartType());
    public static final class_2591<TileVoidTank> TILE_VOID_TANK_TYPE = FabricBlockEntityTypeBuilder.create(TileVoidTank::new, (class_2248[])new class_2248[]{BLOCK_VOID_TANK}).build(DSL.emptyPartType());
    public static final class_5339<TankLootFunction> TANK_LOOT_FUNCTION = new class_5339(TankLootFunction.CODEC);
    public static final class_1865<TierRecipe> TIER_RECIPE_SERIALIZER = TierRecipe.SERIALIZER;
    public static final BlockChestAsTank BLOCK_CAT = new BlockChestAsTankFabric();
    public static final class_1747 ITEM_CAT = new ItemChestAsTank(BLOCK_CAT);
    public static final Map<Tier, ItemReservoir> RESERVOIR_MAP = Stream.of(Tier.WOOD, Tier.STONE, Tier.IRON).collect(Collectors.toMap(Function.identity(), ItemReservoir::new));
    public static final class_9331<Tank<FluidLike>> FLUID_TANK_DATA_COMPONENT = class_9331.method_57873().method_57881(Tank.codec(FluidAmountUtil.access())).method_57880();

    public void onInitialize() {
        FluidTankCommon.LOGGER.info(FluidTankCommon.INITIALIZATION, "Initialize {}", (Object)"fluidtank");
        PacketHandler.Server.initServer();
        PlatformAccess.setInstance(new FabricPlatformAccess());
        PlatformConfigAccess.setInstance(new FabricPlatformConfigAccess());
        FluidTank.registerObjects();
        ConnectionStorage.register();
        ChestAsTankStorage.register();
        FabricTankItemStorage.register();
        ReservoirFluidStorage.register();
        ServerLifecycleEvents.SERVER_STARTED.register(FluidTank::onServerStart);
        FluidTankCommon.LOGGER.info(FluidTankCommon.INITIALIZATION, "Initialize finished {}", (Object)"fluidtank");
    }

    private static void registerObjects() {
        Stream.concat(TANK_MAP.entrySet().stream(), Stream.of(Map.entry(Tier.CREATIVE, BLOCK_CREATIVE_TANK), Map.entry(Tier.VOID, BLOCK_VOID_TANK))).forEach(e -> class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)class_2960.method_60655((String)"fluidtank", (String)((Tier)((Object)((Object)e.getKey()))).getBlockName()), (Object)((Object)((BlockTank)((Object)((Object)e.getValue()))))));
        TANK_ITEM_MAP.forEach((tier, itemBlockTank) -> class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)class_2960.method_60655((String)"fluidtank", (String)tier.getBlockName()), (Object)itemBlockTank));
        Map.of(TileTank.class, TILE_TANK_TYPE, TileCreativeTank.class, TILE_CREATIVE_TANK_TYPE, TileVoidTank.class, TILE_VOID_TANK_TYPE).forEach((c, t) -> class_2378.method_10230((class_2378)class_7923.field_41181, (class_2960)class_2960.method_60655((String)"fluidtank", (String)c.getSimpleName().toLowerCase(Locale.ROOT)), (Object)t));
        class_2378.method_10230((class_2378)class_7923.field_41134, (class_2960)class_2960.method_60655((String)"fluidtank", (String)"content_tank"), TANK_LOOT_FUNCTION);
        class_2378.method_10230((class_2378)class_7923.field_41189, (class_2960)TierRecipe.Serializer.LOCATION, TIER_RECIPE_SERIALIZER);
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)class_2960.method_60655((String)"fluidtank", (String)BlockChestAsTank.NAME()), (Object)((Object)BLOCK_CAT));
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)class_2960.method_60655((String)"fluidtank", (String)BlockChestAsTank.NAME()), (Object)ITEM_CAT);
        RESERVOIR_MAP.values().forEach(e -> class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)class_2960.method_60655((String)"fluidtank", (String)("reservoir_" + e.tier().name().toLowerCase(Locale.ROOT))), (Object)e));
        class_1761.class_7913 builder = FabricItemGroup.builder();
        FluidTank.createTab(builder);
        class_2378.method_10230((class_2378)class_7923.field_44687, (class_2960)class_2960.method_60655((String)"fluidtank", (String)"fluidtank"), (Object)builder.method_47324());
        class_2378.method_10230((class_2378)class_7923.field_49658, (class_2960)class_2960.method_60655((String)"fluidtank", (String)Tank.COMPONENT_NAME()), FLUID_TANK_DATA_COMPONENT);
    }

    private static void createTab(class_1761.class_7913 builder) {
        builder.method_47320(() -> new class_1799((class_1935)TANK_MAP.get((Object)Tier.WOOD)));
        builder.method_47321((class_2561)class_2561.method_43471((String)"itemGroup.fluidtank"));
        builder.method_47317((parameters, output) -> {
            TANK_ITEM_MAP.values().stream().sorted(Comparator.comparing(i -> i.blockTank().tier())).forEach(arg_0 -> ((class_1761.class_7704)output).method_45421(arg_0));
            output.method_45421((class_1935)ITEM_CAT);
            RESERVOIR_MAP.values().stream().sorted(Comparator.comparing(ItemReservoir::tier)).forEach(arg_0 -> ((class_1761.class_7704)output).method_45421(arg_0));
        });
    }

    static void onServerStart(MinecraftServer server) {
        FluidTankCommon.LOGGER.info(FluidTankCommon.INITIALIZATION, "OnServerStart {}, {}", (Object)"fluidtank", (Object)server.method_3818());
        DebugLogging.initialLog(server);
    }
}

