/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.fabric.fluid;

import cats.Invariant$;
import cats.Monad;
import cats.data.Chain;
import cats.data.IndexedReaderWriterStateT;
import com.kotori316.fluidtank.contents.DefaultTransferEnv$;
import com.kotori316.fluidtank.contents.FluidTransferLog;
import com.kotori316.fluidtank.contents.GenericAmount;
import com.kotori316.fluidtank.contents.GenericUnit$;
import com.kotori316.fluidtank.contents.Tank;
import com.kotori316.fluidtank.contents.TransferEnv;
import com.kotori316.fluidtank.fabric.fluid.FabricConverter$;
import com.kotori316.fluidtank.fluids.FluidLike;
import java.io.Serializable;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_3612;
import org.jetbrains.annotations.VisibleForTesting;
import scala.Function1;
import scala.MatchError;
import scala.Tuple3;
import scala.runtime.function.JProcedure1;
import scala.util.Using;
import scala.util.Using$;

public abstract class FabricTankStorage
implements SingleSlotStorage<FluidVariant> {
    private final ContainerItemContext context;

    public FabricTankStorage(ContainerItemContext context) {
        this.context = context;
    }

    public final ContainerItemContext context() {
        return this.context;
    }

    public abstract Tank<FluidLike> getTank();

    public abstract ItemVariant saveTank(Tank<FluidLike> var1);

    public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        Tank<FluidLike> tank = this.getTank();
        return this.move(tank, tank.fillOp(), FabricConverter$.MODULE$.fromVariant(resource, maxAmount), transaction);
    }

    public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        Tank<FluidLike> tank = this.getTank();
        return this.move(tank, tank.drainOp(), FabricConverter$.MODULE$.fromVariant(resource, maxAmount), transaction);
    }

    private long move(Tank<FluidLike> tank, IndexedReaderWriterStateT<Object, TransferEnv, Chain<FluidTransferLog>, GenericAmount<FluidLike>, GenericAmount<FluidLike>, Tank<FluidLike>> op, GenericAmount<FluidLike> fluid, TransactionContext transaction) {
        Tuple3 tuple3 = (Tuple3)op.run((Object)DefaultTransferEnv$.MODULE$, fluid, (Monad)Invariant$.MODULE$.catsInstancesForId());
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        Tuple3 $1$ = tuple3;
        Tuple3 tuple32 = $1$;
        GenericAmount rest = (GenericAmount)tuple32._2();
        Tank result = (Tank)tuple32._3();
        Tank<FluidLike> tank2 = tank;
        Tank tank3 = result;
        if ((tank2 == null ? tank3 != null : !((Object)tank2).equals(tank3)) && this.context().exchange(this.saveTank(result), 1L, transaction) == 1L) {
            GenericAmount<FluidLike> inserted = fluid.operatorMinus(rest);
            return GenericUnit$.MODULE$.asFabric$extension(inserted.amount());
        }
        return 0L;
    }

    public boolean isResourceBlank() {
        return this.getTank().content().isContentEmpty();
    }

    public FluidVariant getResource() {
        return FabricConverter$.MODULE$.toVariant(this.getTank().content(), class_3612.field_15906);
    }

    public long getAmount() {
        return GenericUnit$.MODULE$.asFabric$extension(this.getTank().content().amount());
    }

    public long getCapacity() {
        return GenericUnit$.MODULE$.asFabric$extension(this.getTank().capacity());
    }

    @VisibleForTesting
    public void fill(GenericAmount<FluidLike> amount) {
        Using$.MODULE$.apply(FabricTankStorage::fill$$anonfun$1, (Function1)(JProcedure1 & Serializable)transaction -> {
            Tank<FluidLike> tank = this.getTank();
            this.move(tank, tank.fillOp(), amount, (TransactionContext)transaction);
            transaction.commit();
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    @VisibleForTesting
    public class_1799 getStack() {
        return this.context().getItemVariant().toStack((int)this.context().getAmount());
    }

    private static final Transaction fill$$anonfun$1() {
        return Transaction.openOuter();
    }
}

