/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.fabric.render;

import com.kotori316.fluidtank.contents.GenericAmount;
import com.kotori316.fluidtank.contents.Tank;
import com.kotori316.fluidtank.fabric.fluid.FabricConverter;
import com.kotori316.fluidtank.fluids.FluidAmountUtil;
import com.kotori316.fluidtank.fluids.FluidLike;
import com.kotori316.fluidtank.fluids.VanillaFluid;
import com.kotori316.fluidtank.fluids.VanillaPotion;
import com.kotori316.fluidtank.render.FluidRenderHelper;
import java.util.Objects;
import java.util.function.Function;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1058;
import net.minecraft.class_11701;
import net.minecraft.class_1844;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public final class FluidRenderHelperFabric
implements FluidRenderHelper {
    static class_1058 getSprite(GenericAmount<FluidLike> fluid) {
        return FluidVariantRendering.getSprite((FluidVariant)FabricConverter.toVariant(fluid, (class_3611)class_3612.field_15910));
    }

    static int getColor(GenericAmount<FluidLike> fluid) {
        if (fluid.content() instanceof VanillaFluid) {
            return FluidVariantRendering.getColor((FluidVariant)FabricConverter.toVariant(fluid, class_3612.field_15906));
        }
        if (fluid.content() instanceof VanillaPotion) {
            return FluidAmountUtil.getComponentPatch(fluid).map(p -> p.method_57845(class_9334.field_49651)).flatMap(Function.identity()).map(class_1844::method_8064).orElse(0xF800F8);
        }
        throw new AssertionError();
    }

    static int getColorWithPos(GenericAmount<FluidLike> fluid, @Nullable class_1920 view, class_2338 pos) {
        if (fluid.content() instanceof VanillaFluid) {
            return FluidVariantRendering.getColor((FluidVariant)FabricConverter.toVariant(fluid, class_3612.field_15906), (class_1920)view, (class_2338)pos);
        }
        return FluidRenderHelperFabric.getColor(fluid);
    }

    static int getLuminance(GenericAmount<FluidLike> fluid) {
        return FluidVariantAttributes.getLuminance((FluidVariant)FabricConverter.toVariant(fluid, class_3612.field_15906));
    }

    @Override
    public class_1058 getFluidTexture(Tank<FluidLike> tank, class_11701 materialSet) {
        return FluidRenderHelperFabric.getSprite(tank.content());
    }

    @Override
    public int getFluidColor(Tank<FluidLike> tank) {
        return FluidRenderHelperFabric.getColorWithPos(tank.content(), (class_1920)class_310.method_1551().field_1687, Objects.requireNonNull(class_310.method_1551().field_1724).method_23312());
    }
}

