/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.recipe;

import com.kotori316.fluidtank.DebugLogging;
import com.kotori316.fluidtank.contents.GenericAmount;
import com.kotori316.fluidtank.contents.GenericUnit;
import com.kotori316.fluidtank.contents.Tank;
import com.kotori316.fluidtank.contents.TankUtil;
import com.kotori316.fluidtank.fluids.FluidAmountUtil;
import com.kotori316.fluidtank.fluids.FluidLike;
import com.kotori316.fluidtank.fluids.FluidLikeKey;
import com.kotori316.fluidtank.item.PlatformItemAccess;
import com.kotori316.fluidtank.tank.BlockTank;
import com.kotori316.fluidtank.tank.ItemBlockTank;
import com.kotori316.fluidtank.tank.PlatformTankAccess;
import com.kotori316.fluidtank.tank.Tier;
import com.kotori316.fluidtank.tank.TileTank;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_10295;
import net.minecraft.class_10300;
import net.minecraft.class_10302;
import net.minecraft.class_11362;
import net.minecraft.class_11580;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3955;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_8942;
import net.minecraft.class_8957;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9334;
import net.minecraft.class_9694;
import net.minecraft.class_9887;
import org.apache.logging.log4j.util.Lazy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TierRecipe
implements class_3955 {
    private static final Logger LOGGER = LoggerFactory.getLogger(TierRecipe.class);
    public static final Serializer SERIALIZER = new Serializer();
    final Tier tier;
    final class_1856 tankItem;
    final class_1856 subItem;
    final class_1799 result;
    final class_8957 pattern;
    final Lazy<class_9887> placementInfo;
    public static final String KEY_TIER = "tier";
    public static final String KEY_SUB_ITEM = "sub_item";

    public TierRecipe(Tier tier, class_1856 tankItem, class_1856 subItem) {
        this.tier = tier;
        this.tankItem = tankItem;
        this.subItem = subItem;
        this.result = new class_1799((class_1935)PlatformTankAccess.getInstance().getTankBlockMap().get((Object)tier).get());
        this.pattern = class_8957.method_55085(Map.of(Character.valueOf('t'), tankItem, Character.valueOf('s'), subItem), List.of("tst", "s s", "tst"));
        this.placementInfo = Lazy.lazy(() -> class_9887.method_61683((List)this.pattern.method_59997()));
        DebugLogging.LOGGER().debug("{} instance created for Tier {}({}).", (Object)this.getClass().getSimpleName(), (Object)tier, (Object)this.result);
    }

    public boolean matches(class_9694 input, @Nullable class_1937 worldIn) {
        if (!this.pattern.method_55078(input)) {
            return false;
        }
        List tankStacks = input.method_59989().stream().filter(this.tankItem).toList();
        return tankStacks.size() == 4 && tankStacks.stream().map(s -> (class_11580)s.method_58694(class_9334.field_49611)).filter(Objects::nonNull).map(class_11580::method_72540).flatMap(n -> n.method_10562(TileTank.KEY_TANK()).stream()).map(nbt -> TankUtil.load(nbt, FluidAmountUtil.access())).map(Tank::content).filter(GenericAmount::nonEmpty).map(FluidLikeKey::from).distinct().count() <= 1L;
    }

    @NotNull
    public class_1799 assemble(class_9694 inv, class_7225.class_7874 access) {
        if (!this.matches(inv, null)) {
            List stacks = inv.method_59989();
            LOGGER.error("Requested to return crafting result for invalid inventory. {}", (Object)stacks);
            DebugLogging.LOGGER().error("Requested to return crafting result for invalid inventory. {}", (Object)stacks);
            return class_1799.field_8037;
        }
        class_1799 result = this.result.method_7972();
        GenericAmount<FluidLike> fluidAmount = IntStream.range(0, inv.method_59983()).mapToObj(arg_0 -> ((class_9694)inv).method_59984(arg_0)).filter(s -> s.method_7909() instanceof ItemBlockTank).map(s -> (class_11580)s.method_58694(class_9334.field_49611)).filter(Objects::nonNull).map(class_11580::method_72540).flatMap(n -> n.method_10562(TileTank.KEY_TANK()).stream()).map(nbt -> TankUtil.load(nbt, FluidAmountUtil.access())).map(Tank::content).filter(GenericAmount::nonEmpty).reduce(GenericAmount::add).orElse(FluidAmountUtil.EMPTY());
        if (fluidAmount.nonEmpty()) {
            try (class_8942.class_11340 reporter = new class_8942.class_11340(LOGGER);){
                class_11362 tagValueOutput = class_11362.method_71459((class_8942)reporter, (class_7225.class_7874)access);
                Tank<FluidLike> tank = new Tank<FluidLike>(fluidAmount, GenericUnit.apply(this.tier.getCapacity()));
                tagValueOutput.method_71468(TileTank.KEY_TANK(), Tank.codec(FluidAmountUtil.access()), tank);
                tagValueOutput.method_71469(TileTank.KEY_TIER(), this.tier.name());
                PlatformItemAccess.setTileTag(result, tagValueOutput, PlatformTankAccess.getInstance().getNormalType());
            }
        }
        return result;
    }

    @NotNull
    public class_1865<TierRecipe> method_8119() {
        return SERIALIZER;
    }

    public class_9887 method_61671() {
        return (class_9887)this.placementInfo.get();
    }

    public List<class_10295> method_64664() {
        return List.of(new class_10300(this.pattern.method_59995(), this.pattern.method_59996(), this.pattern.method_59997().stream().map(optional -> optional.map(class_1856::method_64673).orElse((class_10302)class_10302.class_10305.field_54681)).toList(), (class_10302)new class_10302.class_10307(this.result), (class_10302)new class_10302.class_10306(class_1802.field_8465)));
    }

    @NotNull
    public class_2371<class_1799> method_17704(class_9694 inv) {
        return IntStream.range(0, inv.method_59983()).mapToObj(arg_0 -> ((class_9694)inv).method_59984(arg_0)).map(stack -> {
            if (stack.method_7909() instanceof ItemBlockTank) {
                return class_1799.field_8037;
            }
            return PlatformItemAccess.getInstance().getCraftingRemainingItem((class_1799)stack);
        }).collect(Collectors.toCollection(class_2371::method_10211));
    }

    public Tier getTier() {
        return this.tier;
    }

    private class_1856 getSubItem() {
        return this.subItem;
    }

    public class_1799 getResult() {
        return this.result.method_7972();
    }

    @NotNull
    public class_7710 method_45441() {
        return class_7710.field_40251;
    }

    public static final class Serializer
    implements class_1865<TierRecipe> {
        public static final class_2960 LOCATION = class_2960.method_60655((String)"fluidtank", (String)"crafting_grade_up");
        private final MapCodec<TierRecipe> codec = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.xmap(Tier::valueOfIgnoreCase, Enum::name).fieldOf(TierRecipe.KEY_TIER).forGetter(TierRecipe::getTier), (App)class_1856.field_46095.fieldOf(TierRecipe.KEY_SUB_ITEM).forGetter(TierRecipe::getSubItem)).apply((Applicative)instance, this::createInstanceInternal));
        private final class_9139<class_9129, TierRecipe> streamCodec = class_9139.method_56438(this::toNetwork, this::fromNetwork);

        private TierRecipe createInstance(Tier tier, class_1856 tankItem, class_1856 subItem) {
            return new TierRecipe(tier, tankItem, subItem);
        }

        private TierRecipe createInstanceInternal(Tier tier, class_1856 subItem) {
            return this.createInstance(tier, Serializer.getIngredientTankForTier(tier), subItem);
        }

        @NotNull
        public MapCodec<TierRecipe> method_53736() {
            return this.codec;
        }

        @Deprecated
        @NotNull
        public class_9139<class_9129, TierRecipe> method_56104() {
            return this.streamCodec;
        }

        public TierRecipe fromNetwork(class_9129 buffer) {
            String tierName = buffer.method_19772();
            Tier tier = Tier.valueOf(tierName);
            class_1856 tankItem = (class_1856)class_1856.field_48355.decode((Object)buffer);
            class_1856 subItem = (class_1856)class_1856.field_48355.decode((Object)buffer);
            DebugLogging.LOGGER().debug("Serializer loaded from packet for tier {}, sub {}.", (Object)tier, (Object)PlatformItemAccess.convertIngredientToString(subItem));
            return this.createInstance(tier, tankItem, subItem);
        }

        public void toNetwork(TierRecipe recipe, class_9129 buffer) {
            buffer.method_10814(recipe.tier.name());
            class_1856.field_48355.encode((Object)buffer, (Object)recipe.tankItem);
            class_1856.field_48355.encode((Object)buffer, (Object)recipe.subItem);
            DebugLogging.LOGGER().debug("Serialized to packet for tier {}.", (Object)recipe.tier);
        }

        public static class_1856 getIngredientTankForTier(Tier tier) {
            return class_1856.method_26964(Serializer.getTankForTier(tier));
        }

        public static Stream<? extends BlockTank> getTankForTier(Tier tier) {
            Stream<Tier> targetTiers = Stream.of(Tier.values()).filter(t -> t.getRank() == tier.getRank() - 1);
            return targetTiers.map(PlatformTankAccess.getInstance().getTankBlockMap()::get).map(Supplier::get);
        }
    }
}

