/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.contents;

import cats.Show;
import cats.implicits$;
import com.kotori316.fluidtank.contents.FluidTransferLog$;
import com.kotori316.fluidtank.contents.FluidTransferLog$DrainFailed$;
import com.kotori316.fluidtank.contents.FluidTransferLog$DrainFluid$;
import com.kotori316.fluidtank.contents.FluidTransferLog$FillAll$;
import com.kotori316.fluidtank.contents.FluidTransferLog$FillFailed$;
import com.kotori316.fluidtank.contents.FluidTransferLog$FillFluid$;
import com.kotori316.fluidtank.contents.GenericAmount;
import com.kotori316.fluidtank.contents.GenericAmount$;
import com.kotori316.fluidtank.contents.Tank;
import java.io.Serializable;
import scala.Product;
import scala.StringContext$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.hashing.MurmurHash3$;

public interface FluidTransferLog {
    public static int ordinal(FluidTransferLog fluidTransferLog) {
        return FluidTransferLog$.MODULE$.ordinal(fluidTransferLog);
    }

    public static Show<FluidTransferLog> showFluidTransferLog() {
        return FluidTransferLog$.MODULE$.showFluidTransferLog();
    }

    public String logString();

    public static String toString$(FluidTransferLog $this) {
        return $this.toString();
    }

    default public String toString() {
        return this.logString();
    }

    public boolean isValidTransfer();

    public static class DrainFailed<A>
    implements FluidTransferLog,
    Product,
    Serializable {
        private final GenericAmount<A> fluid;
        private final Tank<A> tank;

        public static <A> DrainFailed<A> apply(GenericAmount<A> genericAmount, Tank<A> tank) {
            return FluidTransferLog$DrainFailed$.MODULE$.apply(genericAmount, tank);
        }

        public static DrainFailed<?> fromProduct(Product product) {
            return FluidTransferLog$DrainFailed$.MODULE$.fromProduct(product);
        }

        public static <A> DrainFailed<A> unapply(DrainFailed<A> drainFailed) {
            return FluidTransferLog$DrainFailed$.MODULE$.unapply(drainFailed);
        }

        public DrainFailed(GenericAmount<A> fluid, Tank<A> tank) {
            this.fluid = fluid;
            this.tank = tank;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, 406043242, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            DrainFailed drainFailed;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DrainFailed)) return false;
            DrainFailed drainFailed2 = drainFailed = (DrainFailed)object;
            GenericAmount<A> genericAmount = this.fluid();
            GenericAmount<A> genericAmount2 = drainFailed2.fluid();
            if (genericAmount == null) {
                if (genericAmount2 != null) {
                    return false;
                }
            } else if (!((Object)genericAmount).equals(genericAmount2)) return false;
            Tank<A> tank = this.tank();
            Tank<A> tank2 = drainFailed2.tank();
            if (tank == null) {
                if (tank2 != null) {
                    return false;
                }
            } else if (!((Object)tank).equals(tank2)) return false;
            if (!drainFailed2.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof DrainFailed;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "DrainFailed";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "fluid";
            }
            if (1 == n2) {
                return "tank";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public GenericAmount<A> fluid() {
            return this.fluid;
        }

        public Tank<A> tank() {
            return this.tank;
        }

        @Override
        public String logString() {
            return Show.ShowInterpolator$.MODULE$.show$extension(implicits$.MODULE$.showInterpolator(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"DrainFailed[FailedToDrain=", ", Tank=", "]"}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Show.Shown[]{new Show.Shown(Show.Shown$.MODULE$.mat(this.fluid(), GenericAmount$.MODULE$.showGenericAmount())), new Show.Shown(Show.Shown$.MODULE$.mat(this.tank().content(), GenericAmount$.MODULE$.showGenericAmount()))}));
        }

        @Override
        public boolean isValidTransfer() {
            return this.fluid().nonEmpty() && this.tank().hasContent();
        }

        public <A> DrainFailed<A> copy(GenericAmount<A> fluid, Tank<A> tank) {
            return new DrainFailed<A>(fluid, tank);
        }

        public <A> GenericAmount<A> copy$default$1() {
            return this.fluid();
        }

        public <A> Tank<A> copy$default$2() {
            return this.tank();
        }

        public GenericAmount<A> _1() {
            return this.fluid();
        }

        public Tank<A> _2() {
            return this.tank();
        }
    }

    public static class DrainFluid<A>
    implements FluidTransferLog,
    Product,
    Serializable {
        private final GenericAmount<A> toDrain;
        private final GenericAmount<A> drained;
        private final Tank<A> before;
        private final Tank<A> after;

        public static <A> DrainFluid<A> apply(GenericAmount<A> genericAmount, GenericAmount<A> genericAmount2, Tank<A> tank, Tank<A> tank2) {
            return FluidTransferLog$DrainFluid$.MODULE$.apply(genericAmount, genericAmount2, tank, tank2);
        }

        public static DrainFluid<?> fromProduct(Product product) {
            return FluidTransferLog$DrainFluid$.MODULE$.fromProduct(product);
        }

        public static <A> DrainFluid<A> unapply(DrainFluid<A> drainFluid) {
            return FluidTransferLog$DrainFluid$.MODULE$.unapply(drainFluid);
        }

        public DrainFluid(GenericAmount<A> toDrain, GenericAmount<A> drained, Tank<A> before, Tank<A> after) {
            this.toDrain = toDrain;
            this.drained = drained;
            this.before = before;
            this.after = after;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, -793692441, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            DrainFluid drainFluid;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DrainFluid)) return false;
            DrainFluid drainFluid2 = drainFluid = (DrainFluid)object;
            GenericAmount<A> genericAmount = this.toDrain();
            GenericAmount<A> genericAmount2 = drainFluid2.toDrain();
            if (genericAmount == null) {
                if (genericAmount2 != null) {
                    return false;
                }
            } else if (!((Object)genericAmount).equals(genericAmount2)) return false;
            GenericAmount<A> genericAmount3 = this.drained();
            GenericAmount<A> genericAmount4 = drainFluid2.drained();
            if (genericAmount3 == null) {
                if (genericAmount4 != null) {
                    return false;
                }
            } else if (!((Object)genericAmount3).equals(genericAmount4)) return false;
            Tank<A> tank = this.before();
            Tank<A> tank2 = drainFluid2.before();
            if (tank == null) {
                if (tank2 != null) {
                    return false;
                }
            } else if (!((Object)tank).equals(tank2)) return false;
            Tank<A> tank3 = this.after();
            Tank<A> tank4 = drainFluid2.after();
            if (tank3 == null) {
                if (tank4 != null) {
                    return false;
                }
            } else if (!((Object)tank3).equals(tank4)) return false;
            if (!drainFluid2.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof DrainFluid;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "DrainFluid";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "toDrain";
                }
                case 1: {
                    return "drained";
                }
                case 2: {
                    return "before";
                }
                case 3: {
                    return "after";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public GenericAmount<A> toDrain() {
            return this.toDrain;
        }

        public GenericAmount<A> drained() {
            return this.drained;
        }

        public Tank<A> before() {
            return this.before;
        }

        public Tank<A> after() {
            return this.after;
        }

        @Override
        public String logString() {
            return Show.ShowInterpolator$.MODULE$.show$extension(implicits$.MODULE$.showInterpolator(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"DrainFluid[Drained=", ", ToDrain=", ", Before=", ", After=", "]"}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Show.Shown[]{new Show.Shown(Show.Shown$.MODULE$.mat(this.drained(), GenericAmount$.MODULE$.showGenericAmount())), new Show.Shown(Show.Shown$.MODULE$.mat(this.toDrain(), GenericAmount$.MODULE$.showGenericAmount())), new Show.Shown(Show.Shown$.MODULE$.mat(this.before().content(), GenericAmount$.MODULE$.showGenericAmount())), new Show.Shown(Show.Shown$.MODULE$.mat(this.after().content(), GenericAmount$.MODULE$.showGenericAmount()))}));
        }

        @Override
        public boolean isValidTransfer() {
            return this.toDrain().nonEmpty();
        }

        public <A> DrainFluid<A> copy(GenericAmount<A> toDrain, GenericAmount<A> drained, Tank<A> before, Tank<A> after) {
            return new DrainFluid<A>(toDrain, drained, before, after);
        }

        public <A> GenericAmount<A> copy$default$1() {
            return this.toDrain();
        }

        public <A> GenericAmount<A> copy$default$2() {
            return this.drained();
        }

        public <A> Tank<A> copy$default$3() {
            return this.before();
        }

        public <A> Tank<A> copy$default$4() {
            return this.after();
        }

        public GenericAmount<A> _1() {
            return this.toDrain();
        }

        public GenericAmount<A> _2() {
            return this.drained();
        }

        public Tank<A> _3() {
            return this.before();
        }

        public Tank<A> _4() {
            return this.after();
        }
    }

    public static class FillAll<A>
    implements FluidTransferLog,
    Product,
    Serializable {
        private final GenericAmount<A> fluid;
        private final Tank<A> tank;

        public static <A> FillAll<A> apply(GenericAmount<A> genericAmount, Tank<A> tank) {
            return FluidTransferLog$FillAll$.MODULE$.apply(genericAmount, tank);
        }

        public static FillAll<?> fromProduct(Product product) {
            return FluidTransferLog$FillAll$.MODULE$.fromProduct(product);
        }

        public static <A> FillAll<A> unapply(FillAll<A> fillAll) {
            return FluidTransferLog$FillAll$.MODULE$.unapply(fillAll);
        }

        public FillAll(GenericAmount<A> fluid, Tank<A> tank) {
            this.fluid = fluid;
            this.tank = tank;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, 1772757661, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            FillAll fillAll;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof FillAll)) return false;
            FillAll fillAll2 = fillAll = (FillAll)object;
            GenericAmount<A> genericAmount = this.fluid();
            GenericAmount<A> genericAmount2 = fillAll2.fluid();
            if (genericAmount == null) {
                if (genericAmount2 != null) {
                    return false;
                }
            } else if (!((Object)genericAmount).equals(genericAmount2)) return false;
            Tank<A> tank = this.tank();
            Tank<A> tank2 = fillAll2.tank();
            if (tank == null) {
                if (tank2 != null) {
                    return false;
                }
            } else if (!((Object)tank).equals(tank2)) return false;
            if (!fillAll2.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof FillAll;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "FillAll";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "fluid";
            }
            if (1 == n2) {
                return "tank";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public GenericAmount<A> fluid() {
            return this.fluid;
        }

        public Tank<A> tank() {
            return this.tank;
        }

        @Override
        public String logString() {
            return Show.ShowInterpolator$.MODULE$.show$extension(implicits$.MODULE$.showInterpolator(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"FillAll[Filled=", ", Tank=", "]"}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Show.Shown[]{new Show.Shown(Show.Shown$.MODULE$.mat(this.fluid(), GenericAmount$.MODULE$.showGenericAmount())), new Show.Shown(Show.Shown$.MODULE$.mat(this.tank().content(), GenericAmount$.MODULE$.showGenericAmount()))}));
        }

        @Override
        public boolean isValidTransfer() {
            return this.fluid().nonEmpty();
        }

        public <A> FillAll<A> copy(GenericAmount<A> fluid, Tank<A> tank) {
            return new FillAll<A>(fluid, tank);
        }

        public <A> GenericAmount<A> copy$default$1() {
            return this.fluid();
        }

        public <A> Tank<A> copy$default$2() {
            return this.tank();
        }

        public GenericAmount<A> _1() {
            return this.fluid();
        }

        public Tank<A> _2() {
            return this.tank();
        }
    }

    public static class FillFailed<A>
    implements FluidTransferLog,
    Product,
    Serializable {
        private final GenericAmount<A> fluid;
        private final Tank<A> tank;

        public static <A> FillFailed<A> apply(GenericAmount<A> genericAmount, Tank<A> tank) {
            return FluidTransferLog$FillFailed$.MODULE$.apply(genericAmount, tank);
        }

        public static FillFailed<?> fromProduct(Product product) {
            return FluidTransferLog$FillFailed$.MODULE$.fromProduct(product);
        }

        public static <A> FillFailed<A> unapply(FillFailed<A> fillFailed) {
            return FluidTransferLog$FillFailed$.MODULE$.unapply(fillFailed);
        }

        public FillFailed(GenericAmount<A> fluid, Tank<A> tank) {
            this.fluid = fluid;
            this.tank = tank;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, -12501248, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            FillFailed fillFailed;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof FillFailed)) return false;
            FillFailed fillFailed2 = fillFailed = (FillFailed)object;
            GenericAmount<A> genericAmount = this.fluid();
            GenericAmount<A> genericAmount2 = fillFailed2.fluid();
            if (genericAmount == null) {
                if (genericAmount2 != null) {
                    return false;
                }
            } else if (!((Object)genericAmount).equals(genericAmount2)) return false;
            Tank<A> tank = this.tank();
            Tank<A> tank2 = fillFailed2.tank();
            if (tank == null) {
                if (tank2 != null) {
                    return false;
                }
            } else if (!((Object)tank).equals(tank2)) return false;
            if (!fillFailed2.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof FillFailed;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "FillFailed";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "fluid";
            }
            if (1 == n2) {
                return "tank";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public GenericAmount<A> fluid() {
            return this.fluid;
        }

        public Tank<A> tank() {
            return this.tank;
        }

        @Override
        public String logString() {
            return Show.ShowInterpolator$.MODULE$.show$extension(implicits$.MODULE$.showInterpolator(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"FillFailed[FailedToFill=", ", Tank=", "]"}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Show.Shown[]{new Show.Shown(Show.Shown$.MODULE$.mat(this.fluid(), GenericAmount$.MODULE$.showGenericAmount())), new Show.Shown(Show.Shown$.MODULE$.mat(this.tank().content(), GenericAmount$.MODULE$.showGenericAmount()))}));
        }

        @Override
        public boolean isValidTransfer() {
            return this.fluid().nonEmpty();
        }

        public <A> FillFailed<A> copy(GenericAmount<A> fluid, Tank<A> tank) {
            return new FillFailed<A>(fluid, tank);
        }

        public <A> GenericAmount<A> copy$default$1() {
            return this.fluid();
        }

        public <A> Tank<A> copy$default$2() {
            return this.tank();
        }

        public GenericAmount<A> _1() {
            return this.fluid();
        }

        public Tank<A> _2() {
            return this.tank();
        }
    }

    public static class FillFluid<A>
    implements FluidTransferLog,
    Product,
    Serializable {
        private final GenericAmount<A> toFill;
        private final GenericAmount<A> filled;
        private final Tank<A> before;
        private final Tank<A> after;

        public static <A> FillFluid<A> apply(GenericAmount<A> genericAmount, GenericAmount<A> genericAmount2, Tank<A> tank, Tank<A> tank2) {
            return FluidTransferLog$FillFluid$.MODULE$.apply(genericAmount, genericAmount2, tank, tank2);
        }

        public static FillFluid<?> fromProduct(Product product) {
            return FluidTransferLog$FillFluid$.MODULE$.fromProduct(product);
        }

        public static <A> FillFluid<A> unapply(FillFluid<A> fillFluid) {
            return FluidTransferLog$FillFluid$.MODULE$.unapply(fillFluid);
        }

        public FillFluid(GenericAmount<A> toFill, GenericAmount<A> filled, Tank<A> before, Tank<A> after) {
            this.toFill = toFill;
            this.filled = filled;
            this.before = before;
            this.after = after;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, -521451979, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            FillFluid fillFluid;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof FillFluid)) return false;
            FillFluid fillFluid2 = fillFluid = (FillFluid)object;
            GenericAmount<A> genericAmount = this.toFill();
            GenericAmount<A> genericAmount2 = fillFluid2.toFill();
            if (genericAmount == null) {
                if (genericAmount2 != null) {
                    return false;
                }
            } else if (!((Object)genericAmount).equals(genericAmount2)) return false;
            GenericAmount<A> genericAmount3 = this.filled();
            GenericAmount<A> genericAmount4 = fillFluid2.filled();
            if (genericAmount3 == null) {
                if (genericAmount4 != null) {
                    return false;
                }
            } else if (!((Object)genericAmount3).equals(genericAmount4)) return false;
            Tank<A> tank = this.before();
            Tank<A> tank2 = fillFluid2.before();
            if (tank == null) {
                if (tank2 != null) {
                    return false;
                }
            } else if (!((Object)tank).equals(tank2)) return false;
            Tank<A> tank3 = this.after();
            Tank<A> tank4 = fillFluid2.after();
            if (tank3 == null) {
                if (tank4 != null) {
                    return false;
                }
            } else if (!((Object)tank3).equals(tank4)) return false;
            if (!fillFluid2.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof FillFluid;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "FillFluid";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "toFill";
                }
                case 1: {
                    return "filled";
                }
                case 2: {
                    return "before";
                }
                case 3: {
                    return "after";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public GenericAmount<A> toFill() {
            return this.toFill;
        }

        public GenericAmount<A> filled() {
            return this.filled;
        }

        public Tank<A> before() {
            return this.before;
        }

        public Tank<A> after() {
            return this.after;
        }

        @Override
        public String logString() {
            return Show.ShowInterpolator$.MODULE$.show$extension(implicits$.MODULE$.showInterpolator(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"FillFluid[Filled=", ", ToFill=", ", Before=", ", After=", "]"}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Show.Shown[]{new Show.Shown(Show.Shown$.MODULE$.mat(this.filled(), GenericAmount$.MODULE$.showGenericAmount())), new Show.Shown(Show.Shown$.MODULE$.mat(this.toFill(), GenericAmount$.MODULE$.showGenericAmount())), new Show.Shown(Show.Shown$.MODULE$.mat(this.before().content(), GenericAmount$.MODULE$.showGenericAmount())), new Show.Shown(Show.Shown$.MODULE$.mat(this.after().content(), GenericAmount$.MODULE$.showGenericAmount()))}));
        }

        @Override
        public boolean isValidTransfer() {
            return this.toFill().nonEmpty();
        }

        public <A> FillFluid<A> copy(GenericAmount<A> toFill, GenericAmount<A> filled, Tank<A> before, Tank<A> after) {
            return new FillFluid<A>(toFill, filled, before, after);
        }

        public <A> GenericAmount<A> copy$default$1() {
            return this.toFill();
        }

        public <A> GenericAmount<A> copy$default$2() {
            return this.filled();
        }

        public <A> Tank<A> copy$default$3() {
            return this.before();
        }

        public <A> Tank<A> copy$default$4() {
            return this.after();
        }

        public GenericAmount<A> _1() {
            return this.toFill();
        }

        public GenericAmount<A> _2() {
            return this.filled();
        }

        public Tank<A> _3() {
            return this.before();
        }

        public Tank<A> _4() {
            return this.after();
        }
    }
}

