/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.contents;

import com.kotori316.fluidtank.FluidTankCommon;
import com.kotori316.fluidtank.contents.CreativeTank;
import com.kotori316.fluidtank.contents.GenericAccess;
import com.kotori316.fluidtank.contents.GenericAmount;
import com.kotori316.fluidtank.contents.GenericUnit$;
import com.kotori316.fluidtank.contents.Tank;
import com.kotori316.fluidtank.contents.Tank$;
import com.kotori316.fluidtank.contents.TankUtil;
import com.kotori316.fluidtank.contents.TankUtil$TankType$;
import com.kotori316.fluidtank.contents.VoidTank;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.io.Serializable;
import java.nio.ByteBuffer;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_9326;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.math.BigInt;
import scala.runtime.ModuleSerializationProxy;

public final class TankUtil$
implements Serializable {
    private static final Codec<TankUtil.TankType> tankTypeCodec;
    public static final TankUtil$TankType$ TankType;
    public static final TankUtil$ MODULE$;

    private TankUtil$() {
    }

    static {
        MODULE$ = new TankUtil$();
        tankTypeCodec = Codec.STRING.flatXmap(name -> {
            Option<TankUtil.TankType> option = this.typeByName((String)name);
            if (option instanceof Some) {
                Some some = (Some)option;
                TankUtil.TankType value = (TankUtil.TankType)some.value();
                return DataResult.success((Object)value);
            }
            if (None$.MODULE$.equals(option)) {
                return DataResult.error(() -> "Unknown type of tank (" + name + ")");
            }
            throw new MatchError(option);
        }, t -> DataResult.success((Object)t.name()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TankUtil$.class);
    }

    public final String KEY_TYPE() {
        return "type";
    }

    public final Codec<TankUtil.TankType> tankTypeCodec() {
        return tankTypeCodec;
    }

    private Option<TankUtil.TankType> typeByName(String name) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])TankUtil$TankType$.MODULE$.values());
        return ArrayOps$.MODULE$.find$extension(object, (Function1 & Serializable)_$1 -> {
            String string = _$1.name();
            String string2 = name;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    public <A> class_2487 save(Tank<A> tank, GenericAccess<A> access) {
        return Tank$.MODULE$.codec(access).encodeStart((DynamicOps)class_2509.field_11560, tank).result().flatMap(_$2 -> _$2.method_68571()).orElse(new class_2487());
    }

    public <A> Tank<A> load(class_2487 tag, GenericAccess<A> access) {
        return (Tank)Tank$.MODULE$.codec(access).parse((DynamicOps)class_2509.field_11560, (Object)tag).mapOrElse(t -> t, error -> {
            FluidTankCommon.logOnceInMinute("TankUtil.load failed", () -> "tag: " + tag, () -> new IllegalArgumentException(error.message()));
            return Tank$.MODULE$.apply(access.newInstance(access.empty(), GenericUnit$.MODULE$.ZERO(), (Option<class_9326>)Option$.MODULE$.empty()), GenericUnit$.MODULE$.ZERO());
        });
    }

    public <A> Tank<A> createTank(GenericAmount<A> content, ByteBuffer byteBuffer, TankUtil.TankType tankType) {
        BigInt capacity = GenericUnit$.MODULE$.fromByteArray(byteBuffer.array());
        return this.createTank(content, capacity, tankType);
    }

    private <A> Tank<A> createTank(GenericAmount<A> content, BigInt capacity, TankUtil.TankType tankType) {
        TankUtil.TankType tankType2 = tankType;
        TankUtil.TankType tankType3 = TankUtil$TankType$.TANK;
        TankUtil.TankType tankType4 = tankType2;
        if (!(tankType3 != null ? !tankType3.equals(tankType4) : tankType4 != null)) {
            return Tank$.MODULE$.apply(content, capacity);
        }
        TankUtil.TankType tankType5 = TankUtil$TankType$.CREATIVE_TANK;
        TankUtil.TankType tankType6 = tankType2;
        if (!(tankType5 != null ? !tankType5.equals(tankType6) : tankType6 != null)) {
            return new CreativeTank<A>(content, capacity);
        }
        TankUtil.TankType tankType7 = TankUtil$TankType$.VOID_TANK;
        TankUtil.TankType tankType8 = tankType2;
        if (!(tankType7 != null ? !tankType7.equals(tankType8) : tankType8 != null)) {
            return new VoidTank<A>(content, capacity);
        }
        throw new MatchError((Object)tankType2);
    }

    public TankUtil.TankType getType(Tank<?> tank) {
        Tank<?> tank2 = tank;
        if (tank2 instanceof CreativeTank) {
            CreativeTank creativeTank = (CreativeTank)tank2;
            return TankUtil$TankType$.CREATIVE_TANK;
        }
        if (tank2 instanceof VoidTank) {
            VoidTank voidTank = (VoidTank)tank2;
            return TankUtil$TankType$.VOID_TANK;
        }
        if (tank2 instanceof Tank) {
            Tank<?> tank3 = tank2;
            return TankUtil$TankType$.TANK;
        }
        if (tank2 == null) {
            throw new IllegalArgumentException("Unknown type of tank, %s".formatted(tank));
        }
        throw new MatchError(tank2);
    }
}

