/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.fabric.cat;

import com.kotori316.fluidtank.contents.GenericAmount;
import com.kotori316.fluidtank.fabric.FluidTank;
import com.kotori316.fluidtank.fabric.cat.EmptySlottedFluidStorage;
import com.kotori316.fluidtank.fabric.cat.SingleSlotStorageWrapper;
import com.kotori316.fluidtank.fabric.fluid.FabricConverter;
import com.kotori316.fluidtank.fluids.FluidLike;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import org.jetbrains.annotations.NotNull;

public class ChestAsTankStorage
implements SlottedStorage<FluidVariant> {
    private final SlottedStorage<ItemVariant> items;

    ChestAsTankStorage(SlottedStorage<ItemVariant> items) {
        this.items = items;
    }

    public int getSlotCount() {
        return this.items.getSlotCount();
    }

    public SingleSlotStorage<FluidVariant> getSlot(int slot) {
        SingleSlotStorage itemStorage = this.items.getSlot(slot);
        return ChestAsTankStorage.getFluidVariantSingleSlotStorage((SingleSlotStorage<ItemVariant>)itemStorage);
    }

    private StorageView<FluidVariant> getSlotAsView(int slot) {
        return this.getSlot(slot);
    }

    @NotNull
    private static SingleSlotStorage<FluidVariant> getFluidVariantSingleSlotStorage(SingleSlotStorage<ItemVariant> itemStorage) {
        long count = itemStorage.getAmount();
        if (count != 1L) {
            return EmptySlottedFluidStorage.INSTANCE();
        }
        class_1799 stack = ((ItemVariant)itemStorage.getResource()).toStack();
        Storage fluid = (Storage)FluidStorage.ITEM.find(stack, (Object)ContainerItemContext.ofSingleSlot(itemStorage));
        if (fluid == null) {
            return EmptySlottedFluidStorage.INSTANCE();
        }
        if (fluid instanceof SingleSlotStorage) {
            SingleSlotStorage s = (SingleSlotStorage)fluid;
            return s;
        }
        return new SingleSlotStorageWrapper((Storage<FluidVariant>)fluid);
    }

    public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        long toFill = maxAmount;
        for (int i = 0; i < this.getSlotCount(); ++i) {
            long filled;
            SingleSlotStorage<FluidVariant> storage = this.getSlot(i);
            if (!storage.supportsInsertion() || (toFill -= (filled = storage.insert((Object)resource, toFill, transaction))) > 0L) continue;
            return maxAmount;
        }
        return maxAmount - toFill;
    }

    public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        long toDrain = maxAmount;
        for (int i = 0; i < this.getSlotCount(); ++i) {
            long drained;
            SingleSlotStorage<FluidVariant> storage = this.getSlot(i);
            if (!storage.supportsExtraction() || (toDrain -= (drained = storage.extract((Object)resource, toDrain, transaction))) > 0L) continue;
            return maxAmount;
        }
        return maxAmount - toDrain;
    }

    public Iterator<StorageView<FluidVariant>> iterator() {
        return IntStream.range(0, this.getSlotCount()).mapToObj(this::getSlotAsView).iterator();
    }

    public static void register() {
        FluidStorage.SIDED.registerForBlocks((world, pos, state, blockEntity, context) -> {
            class_2350 facing = (class_2350)state.method_11654((class_2769)class_2741.field_12525);
            Storage itemStorage = (Storage)ItemStorage.SIDED.find(world, pos.method_10093(facing), (Object)facing.method_10153());
            if (itemStorage instanceof SlottedStorage) {
                SlottedStorage s = (SlottedStorage)itemStorage;
                return new ChestAsTankStorage((SlottedStorage<ItemVariant>)s);
            }
            return null;
        }, new class_2248[]{FluidTank.BLOCK_CAT});
    }

    public static List<GenericAmount<FluidLike>> getCATFluids(class_1937 level, class_2338 pos) {
        Object object = FluidStorage.SIDED.find(level, pos, null);
        if (object instanceof ChestAsTankStorage) {
            ChestAsTankStorage storage = (ChestAsTankStorage)object;
            return IntStream.range(0, storage.getSlotCount()).mapToObj(storage::getSlot).filter(Predicate.not(StorageView::isResourceBlank)).collect(Collectors.groupingBy(StorageView::getResource, Collectors.summingLong(StorageView::getAmount))).entrySet().stream().map(e -> FabricConverter.fromVariant((FluidVariant)e.getKey(), (Long)e.getValue())).toList();
        }
        return List.of();
    }
}

