/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.fabric.tank;

import com.kotori316.fluidtank.contents.GenericAmount;
import com.kotori316.fluidtank.contents.GenericUnit$;
import com.kotori316.fluidtank.fabric.fluid.FabricConverter$;
import com.kotori316.fluidtank.fabric.tank.ConnectionStorage$;
import com.kotori316.fluidtank.fluids.FluidAmountUtil$;
import com.kotori316.fluidtank.fluids.FluidConnection;
import com.kotori316.fluidtank.fluids.FluidLike;
import com.kotori316.fluidtank.fluids.VanillaFluid;
import com.kotori316.fluidtank.fluids.VanillaPotion;
import java.io.Serializable;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_3612;
import scala.Function1;
import scala.MatchError;
import scala.runtime.BoxesRunTime;

public class ConnectionStorage
extends SnapshotParticipant<GenericAmount<FluidLike>>
implements SingleSlotStorage<FluidVariant> {
    private final FluidConnection connection;

    public static void register() {
        ConnectionStorage$.MODULE$.register();
    }

    public ConnectionStorage(FluidConnection connection) {
        this.connection = connection;
    }

    private FluidConnection connection() {
        return this.connection;
    }

    public GenericAmount<FluidLike> createSnapshot() {
        return (GenericAmount)this.connection().getContent().getOrElse(ConnectionStorage::createSnapshot$$anonfun$1);
    }

    public void readSnapshot(GenericAmount<FluidLike> snapshot) {
        this.connection().getHandler().set(snapshot);
    }

    public boolean isResourceBlank() {
        return this.connection().getContent().forall((Function1 & Serializable)f -> {
            FluidLike fluidLike = (FluidLike)f.content();
            if (fluidLike instanceof VanillaFluid) {
                VanillaFluid vanillaFluid = (VanillaFluid)fluidLike;
                return f.isEmpty();
            }
            if (fluidLike instanceof VanillaPotion) {
                VanillaPotion vanillaPotion = (VanillaPotion)fluidLike;
                return true;
            }
            throw new MatchError((Object)fluidLike);
        });
    }

    public FluidVariant getResource() {
        GenericAmount fluid = (GenericAmount)this.connection().getContent().getOrElse(ConnectionStorage::$anonfun$1);
        return FabricConverter$.MODULE$.toVariant(fluid, class_3612.field_15906);
    }

    public long getAmount() {
        return BoxesRunTime.unboxToLong((Object)this.connection().getContent().map((Function1 & Serializable)f -> {
            FluidLike fluidLike = (FluidLike)f.content();
            if (fluidLike instanceof VanillaFluid) {
                VanillaFluid vanillaFluid = (VanillaFluid)fluidLike;
                return GenericUnit$.MODULE$.asFabric$extension(this.connection().amount());
            }
            if (fluidLike instanceof VanillaPotion) {
                VanillaPotion vanillaPotion = (VanillaPotion)fluidLike;
                return 0L;
            }
            throw new MatchError((Object)fluidLike);
        }).getOrElse(ConnectionStorage::getAmount$$anonfun$2));
    }

    public long getCapacity() {
        return GenericUnit$.MODULE$.asFabric$extension(this.connection().capacity());
    }

    public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        GenericAmount<FluidLike> toFill = FabricConverter$.MODULE$.fromVariant(resource, maxAmount);
        this.updateSnapshots(transaction);
        GenericAmount<FluidLike> filled = this.connection().getHandler().fill(toFill, true);
        return GenericUnit$.MODULE$.asFabric$extension(filled.amount());
    }

    public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        GenericAmount<FluidLike> toDrain = FabricConverter$.MODULE$.fromVariant(resource, maxAmount);
        this.updateSnapshots(transaction);
        GenericAmount<FluidLike> drained = this.connection().getHandler().drain(toDrain, true);
        return GenericUnit$.MODULE$.asFabric$extension(drained.amount());
    }

    private static final GenericAmount createSnapshot$$anonfun$1() {
        return FluidAmountUtil$.MODULE$.EMPTY();
    }

    private static final GenericAmount $anonfun$1() {
        return FluidAmountUtil$.MODULE$.EMPTY();
    }

    private static final long getAmount$$anonfun$2() {
        return 0L;
    }
}

