/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.fluids;

import com.kotori316.fluidtank.contents.GenericAmount;
import com.kotori316.fluidtank.fluids.FluidAmountUtil;
import com.kotori316.fluidtank.fluids.FluidLike;
import com.kotori316.fluidtank.fluids.PlatformFluidAccessHolder;
import com.kotori316.fluidtank.fluids.TransferFluid;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.ToLongBiFunction;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1755;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3414;
import net.minecraft.class_3611;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PlatformFluidAccess {
    @NotNull
    public static PlatformFluidAccess getInstance() {
        return PlatformFluidAccessHolder.platformFluidAccess;
    }

    public static void setInstance(@NotNull PlatformFluidAccess access) {
        PlatformFluidAccessHolder.platformFluidAccess = access;
    }

    public boolean isGaseous(class_3611 var1);

    @NotNull
    public class_3611 getBucketContent(class_1755 var1);

    @NotNull
    public GenericAmount<FluidLike> getFluidContained(class_1799 var1);

    public boolean isFluidContainer(class_1799 var1);

    public class_2561 getDisplayName(GenericAmount<FluidLike> var1);

    @NotNull
    public TransferStack fillItem(GenericAmount<FluidLike> var1, class_1799 var2, class_1657 var3, class_1268 var4, boolean var5);

    @NotNull
    public TransferStack drainItem(GenericAmount<FluidLike> var1, class_1799 var2, class_1657 var3, class_1268 var4, boolean var5);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <TRANSACTION extends AutoCloseable> TransferStack moveItemInTransaction(class_1799 stack, class_1657 player, boolean execute, TransferStack result, Supplier<TRANSACTION> startTransaction, Consumer<TRANSACTION> transactionCommit, ToLongBiFunction<class_1799, TRANSACTION> exchange) {
        if (!result.moved().nonEmpty()) return result;
        try (AutoCloseable transaction = (AutoCloseable)startTransaction.get();){
            long exchanged = exchange.applyAsLong(result.toReplace(), transaction);
            if (exchanged != 1L) return new TransferStack(FluidAmountUtil.EMPTY(), stack, false);
            if (execute && TransferFluid.shouldMoveItem(player)) {
                transactionCommit.accept(transaction);
            }
            TransferStack transferStack = result.setShouldMove(false);
            return transferStack;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public class_3414 getEmptySound(GenericAmount<FluidLike> var1);

    @Nullable
    public class_3414 getFillSound(GenericAmount<FluidLike> var1);

    public record TransferStack(GenericAmount<FluidLike> moved, class_1799 toReplace, boolean shouldMove) {
        public TransferStack(GenericAmount<FluidLike> moved, class_1799 toReplace) {
            this(moved, toReplace, true);
        }

        public TransferStack setShouldMove(boolean shouldMove) {
            return new TransferStack(this.moved, this.toReplace, shouldMove);
        }
    }
}

