/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.fluids;

import com.kotori316.fluidtank.FluidTankCommon;
import com.kotori316.fluidtank.contents.GenericAmount;
import com.kotori316.fluidtank.contents.GenericUnit;
import com.kotori316.fluidtank.fluids.FluidAmountUtil;
import com.kotori316.fluidtank.fluids.FluidLike;
import com.kotori316.fluidtank.fluids.PlatformFluidAccess;
import com.kotori316.fluidtank.fluids.VanillaFluid;
import com.kotori316.fluidtank.fluids.VanillaPotion;
import com.kotori316.fluidtank.potions.PotionFluidHandler;
import java.lang.reflect.Field;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3486;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PlatformFluidAccessHolder {
    @NotNull
    static PlatformFluidAccess platformFluidAccess = new Default();

    PlatformFluidAccessHolder() {
    }

    @ApiStatus.Internal
    private static final class Default
    implements PlatformFluidAccess {
        private Default() {
        }

        @Override
        public boolean isGaseous(class_3611 fluid) {
            return false;
        }

        @Override
        public class_3611 getBucketContent(class_1755 bucketItem) {
            try {
                Field field = class_1755.class.getDeclaredField("content");
                field.setAccessible(true);
                return (class_3611)field.get(bucketItem);
            }
            catch (ReflectiveOperationException e) {
                FluidTankCommon.LOGGER.error("Got error in getting fluid content of %s. Are you in production?".formatted(bucketItem), (Throwable)e);
                return class_3612.field_15906;
            }
        }

        @Override
        @NotNull
        public GenericAmount<FluidLike> getFluidContained(class_1799 stack) {
            PotionFluidHandler potionHandler = PotionFluidHandler.apply(stack);
            if (potionHandler.isValidHandler()) {
                return potionHandler.getContent();
            }
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof class_1755) {
                Default access = this;
                class_1755 bucketItem = (class_1755)class_17922;
                class_3611 fluid = access.getBucketContent(bucketItem);
                if (class_3612.field_15906.equals(fluid)) {
                    return FluidAmountUtil.EMPTY();
                }
                return FluidAmountUtil.from(fluid, GenericUnit.ONE_BUCKET());
            }
            return FluidAmountUtil.EMPTY();
        }

        @Override
        public boolean isFluidContainer(class_1799 stack) {
            return stack.method_7909() instanceof class_1755 || PotionFluidHandler.apply(stack).isValidHandler();
        }

        @Override
        public class_2561 getDisplayName(GenericAmount<FluidLike> amount) {
            return class_2561.method_43470((String)FluidAmountUtil.access().asString(amount.content()));
        }

        @Override
        public PlatformFluidAccess.TransferStack fillItem(GenericAmount<FluidLike> toFill, class_1799 fluidContainer, class_1657 player, class_1268 hand, boolean execute) {
            FluidLike filledItem;
            FluidLike fluidLike = toFill.content();
            if (fluidLike instanceof VanillaFluid) {
                VanillaFluid vanillaFluid = (VanillaFluid)fluidLike;
                if (fluidContainer.method_7909() == class_1802.field_8550 && toFill.hasOneBucket()) {
                    filledItem = vanillaFluid.fluid().method_15774().method_7854();
                    GenericAmount<FluidLike> filledAmount = toFill.setAmount(GenericUnit.ONE_BUCKET());
                    return new PlatformFluidAccess.TransferStack(filledAmount, (class_1799)filledItem);
                }
                return new PlatformFluidAccess.TransferStack(FluidAmountUtil.EMPTY(), fluidContainer, false);
            }
            filledItem = toFill.content();
            if (filledItem instanceof VanillaPotion) {
                VanillaPotion vanillaPotion = (VanillaPotion)filledItem;
                PotionFluidHandler handler = PotionFluidHandler.apply(fluidContainer);
                return handler.fill(toFill, vanillaPotion);
            }
            throw new IllegalArgumentException();
        }

        @Override
        public PlatformFluidAccess.TransferStack drainItem(GenericAmount<FluidLike> toDrain, class_1799 fluidContainer, class_1657 player, class_1268 hand, boolean execute) {
            GenericAmount<FluidLike> content = this.getFluidContained(fluidContainer);
            if (toDrain.content() instanceof VanillaFluid) {
                if (!(toDrain.hasOneBucket() && content.hasOneBottle() && toDrain.contentEqual(content))) {
                    return new PlatformFluidAccess.TransferStack(FluidAmountUtil.EMPTY(), fluidContainer, false);
                }
                class_1799 drainedItem = class_1802.field_8550.method_7854();
                GenericAmount<FluidLike> drainedAmount = toDrain.setAmount(GenericUnit.ONE_BUCKET());
                return new PlatformFluidAccess.TransferStack(drainedAmount, drainedItem);
            }
            FluidLike drainedItem = toDrain.content();
            if (drainedItem instanceof VanillaPotion) {
                VanillaPotion v = (VanillaPotion)drainedItem;
                PotionFluidHandler handler = PotionFluidHandler.apply(fluidContainer);
                return handler.drain(toDrain, v);
            }
            throw new AssertionError();
        }

        @Override
        public class_3414 getEmptySound(GenericAmount<FluidLike> fluid) {
            return FluidLike.asFluid(fluid.content(), (class_3611)class_3612.field_15910).method_15791(class_3486.field_15518) ? class_3417.field_15010 : class_3417.field_14834;
        }

        @Override
        @Nullable
        public class_3414 getFillSound(GenericAmount<FluidLike> fluid) {
            return FluidLike.asFluid(fluid.content(), (class_3611)class_3612.field_15910).method_32359().orElse(null);
        }
    }
}

