/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.potions;

import com.kotori316.fluidtank.contents.GenericAmount;
import com.kotori316.fluidtank.contents.GenericUnit$;
import com.kotori316.fluidtank.fluids.FluidAmountUtil$;
import com.kotori316.fluidtank.fluids.FluidLike;
import com.kotori316.fluidtank.fluids.FluidLike$;
import com.kotori316.fluidtank.fluids.PlatformFluidAccess;
import com.kotori316.fluidtank.fluids.PotionType;
import com.kotori316.fluidtank.fluids.VanillaPotion;
import com.kotori316.fluidtank.potions.PotionFluidHandler$;
import java.io.Serializable;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_9326;
import scala.Function1;
import scala.PartialFunction;
import scala.collection.mutable.Seq;
import scala.runtime.function.JProcedure1;

public interface PotionFluidHandler {
    public static PotionFluidHandler apply(class_1799 class_17992) {
        return PotionFluidHandler$.MODULE$.apply(class_17992);
    }

    public static Seq<PartialFunction<class_1799, PotionFluidHandler>> handlerProvider() {
        return PotionFluidHandler$.MODULE$.handlerProvider();
    }

    public PlatformFluidAccess.TransferStack fill(GenericAmount<FluidLike> var1, VanillaPotion var2);

    public PlatformFluidAccess.TransferStack drain(GenericAmount<FluidLike> var1, VanillaPotion var2);

    public GenericAmount<FluidLike> getContent();

    public static boolean isValidHandler$(PotionFluidHandler $this) {
        return $this.isValidHandler();
    }

    default public boolean isValidHandler() {
        return true;
    }

    public static class NotContainer
    implements PotionFluidHandler {
        private final class_1799 stack;

        public NotContainer(class_1799 stack) {
            this.stack = stack;
        }

        @Override
        public PlatformFluidAccess.TransferStack fill(GenericAmount<FluidLike> toFill, VanillaPotion vanillaPotion) {
            return PotionFluidHandler$.MODULE$.com$kotori316$fluidtank$potions$PotionFluidHandler$$$transferFailed(this.stack);
        }

        @Override
        public PlatformFluidAccess.TransferStack drain(GenericAmount<FluidLike> toDrain, VanillaPotion vanillaPotion) {
            return PotionFluidHandler$.MODULE$.com$kotori316$fluidtank$potions$PotionFluidHandler$$$transferFailed(this.stack);
        }

        @Override
        public GenericAmount<FluidLike> getContent() {
            return FluidAmountUtil$.MODULE$.EMPTY();
        }

        @Override
        public boolean isValidHandler() {
            return false;
        }
    }

    public static class VanillaEmptyBottle
    implements PotionFluidHandler {
        private final class_1799 stack;

        public VanillaEmptyBottle(class_1799 stack) {
            this.stack = stack;
        }

        @Override
        public PlatformFluidAccess.TransferStack fill(GenericAmount<FluidLike> toFill, VanillaPotion vanillaPotion) {
            if (toFill.hasOneBottle()) {
                class_1799 filledItem = new class_1799((class_1935)vanillaPotion.potionType().getItem());
                toFill.componentPatch().foreach((Function1)((JProcedure1 & Serializable)arg_0 -> PotionFluidHandler$.com$kotori316$fluidtank$potions$PotionFluidHandler$VanillaEmptyBottle$$_$fill$$anonfun$1(filledItem, arg_0)));
                GenericAmount<FluidLike> moved = toFill.setAmount(GenericUnit$.MODULE$.ONE_BOTTLE());
                return PotionFluidHandler$.MODULE$.com$kotori316$fluidtank$potions$PotionFluidHandler$$$transferStack(moved, filledItem);
            }
            return PotionFluidHandler$.MODULE$.com$kotori316$fluidtank$potions$PotionFluidHandler$$$transferFailed(this.stack);
        }

        @Override
        public PlatformFluidAccess.TransferStack drain(GenericAmount<FluidLike> toDrain, VanillaPotion vanillaPotion) {
            return PotionFluidHandler$.MODULE$.com$kotori316$fluidtank$potions$PotionFluidHandler$$$transferFailed(this.stack);
        }

        @Override
        public GenericAmount<FluidLike> getContent() {
            return FluidAmountUtil$.MODULE$.EMPTY();
        }
    }

    public static class VanillaPotionBottle
    implements PotionFluidHandler {
        private final class_1799 stack;

        public VanillaPotionBottle(class_1799 stack) {
            this.stack = stack;
        }

        @Override
        public PlatformFluidAccess.TransferStack fill(GenericAmount<FluidLike> toFill, VanillaPotion vanillaPotion) {
            return PotionFluidHandler$.MODULE$.com$kotori316$fluidtank$potions$PotionFluidHandler$$$transferFailed(this.stack);
        }

        @Override
        public PlatformFluidAccess.TransferStack drain(GenericAmount<FluidLike> toDrain, VanillaPotion vanillaPotion) {
            if (toDrain.isEmpty() || !toDrain.hasOneBottle()) {
                return PotionFluidHandler$.MODULE$.com$kotori316$fluidtank$potions$PotionFluidHandler$$$transferFailed(this.stack);
            }
            GenericAmount<FluidLike> content = this.getContent();
            if (!content.hasOneBottle() || !toDrain.contentEqual(content)) {
                return PotionFluidHandler$.MODULE$.com$kotori316$fluidtank$potions$PotionFluidHandler$$$transferFailed(this.stack);
            }
            class_1799 drainedItem = class_1802.field_8469.method_7854();
            GenericAmount<FluidLike> moved = toDrain.setAmount(GenericUnit$.MODULE$.ONE_BOTTLE());
            return PotionFluidHandler$.MODULE$.com$kotori316$fluidtank$potions$PotionFluidHandler$$$transferStack(moved, drainedItem);
        }

        @Override
        public GenericAmount<FluidLike> getContent() {
            PotionType potionType = PotionType.fromItemUnsafe(this.stack.method_7909());
            class_9326 componentMap = this.stack.method_57380();
            return FluidAmountUtil$.MODULE$.from((FluidLike)FluidLike$.MODULE$.of(potionType), GenericUnit$.MODULE$.ONE_BOTTLE(), componentMap);
        }
    }
}

