/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.reservoir;

import cats.implicits$;
import com.kotori316.fluidtank.contents.GenericAmount;
import com.kotori316.fluidtank.contents.GenericUnit;
import com.kotori316.fluidtank.contents.GenericUnit$;
import com.kotori316.fluidtank.contents.Tank;
import com.kotori316.fluidtank.contents.Tank$;
import com.kotori316.fluidtank.fluids.FluidAmountUtil$;
import com.kotori316.fluidtank.fluids.FluidLike;
import com.kotori316.fluidtank.fluids.PlatformFluidAccess;
import com.kotori316.fluidtank.fluids.PotionType;
import com.kotori316.fluidtank.fluids.VanillaFluid;
import com.kotori316.fluidtank.fluids.VanillaPotion;
import com.kotori316.fluidtank.item.PlatformItemAccess;
import com.kotori316.fluidtank.tank.Tier;
import java.io.Serializable;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_5328;
import net.minecraft.class_7924;
import net.minecraft.class_9334;
import scala.Function1;
import scala.Option$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.math.BigInt;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

public class ItemReservoir
extends class_1792 {
    private final Tier tier;

    public ItemReservoir(Tier tier) {
        this.tier = tier;
        super(new class_1792.class_1793().method_7889(1).method_63686(class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"fluidtank", (String)("reservoir_" + tier.name().toLowerCase(Locale.ROOT))))));
    }

    public Tier tier() {
        return this.tier;
    }

    public String toString() {
        return "ItemReservoir(" + this.tier().name().toLowerCase(Locale.ROOT) + ")";
    }

    public class_1839 method_7853(class_1799 stack) {
        FluidLike fluidLike = this.getTank(stack).content().content();
        if (fluidLike instanceof VanillaPotion) {
            VanillaPotion vanillaPotion;
            VanillaPotion v = vanillaPotion = (VanillaPotion)fluidLike;
            PotionType potionType = v.potionType();
            PotionType potionType2 = PotionType.NORMAL;
            if (!(potionType != null ? !((Object)((Object)potionType)).equals((Object)potionType2) : potionType2 != null)) {
                return class_1839.field_8946;
            }
        }
        return super.method_7853(stack);
    }

    public int method_7881(class_1799 stack, class_1309 entity) {
        FluidLike fluidLike = this.getTank(stack).content().content();
        if (fluidLike instanceof VanillaPotion) {
            VanillaPotion vanillaPotion;
            VanillaPotion v = vanillaPotion = (VanillaPotion)fluidLike;
            PotionType potionType = v.potionType();
            PotionType potionType2 = PotionType.NORMAL;
            if (!(potionType != null ? !((Object)((Object)potionType)).equals((Object)potionType2) : potionType2 != null)) {
                return 32;
            }
        }
        return super.method_7881(stack, entity);
    }

    public class_1269 method_7836(class_1937 level, class_1657 player, class_1268 usedHand) {
        class_1799 stack = player.method_5998(usedHand);
        GenericAmount<FluidLike> content = this.getTank(stack).content();
        FluidLike fluidLike = content.content();
        if (fluidLike instanceof VanillaPotion) {
            VanillaPotion vanillaPotion;
            VanillaPotion v = vanillaPotion = (VanillaPotion)fluidLike;
            PotionType potionType = v.potionType();
            PotionType potionType2 = PotionType.NORMAL;
            if (!(potionType != null ? !((Object)((Object)potionType)).equals((Object)potionType2) : potionType2 != null)) {
                return class_5328.method_29282((class_1937)level, (class_1657)player, (class_1268)usedHand);
            }
        }
        if (fluidLike instanceof VanillaFluid) {
            VanillaFluid vanillaFluid = (VanillaFluid)fluidLike;
            class_3965 hitResult = class_1792.method_7872((class_1937)level, (class_1657)player, (class_3959.class_242)class_3959.class_242.field_1345);
            class_239.class_240 class_2402 = hitResult.method_17783();
            class_239.class_240 class_2403 = class_239.class_240.field_1332;
            if (class_2402 == null ? class_2403 != null : !class_2402.equals(class_2403)) {
                return class_1269.field_5811;
            }
            return this.fillOrDrainFluidInLevel(hitResult, stack, level, player, content, usedHand);
        }
        return super.method_7836(level, player, usedHand);
    }

    public class_1799 method_7861(class_1799 stack, class_1937 level, class_1309 livingEntity) {
        Tank<FluidLike> tank = this.getTank(stack);
        GenericAmount<FluidLike> content = tank.content();
        FluidLike fluidLike = content.content();
        if (fluidLike instanceof VanillaPotion) {
            VanillaPotion vanillaPotion = (VanillaPotion)fluidLike;
            if (content.hasOneBottle()) {
                content.componentPatch().iterator().foreach((Function1)(JProcedure1 & Serializable)patch -> Option$.MODULE$.apply((Object)patch.method_57845(class_9334.field_49651)).flatMap((Function1 & Serializable)_$1 -> {
                    Optional optional = OptionConverters$.MODULE$.RichOptional(_$1);
                    return OptionConverters.RichOptional$.MODULE$.toScala$extension(optional);
                }).iterator().foreach((Function1)(JProcedure1 & Serializable)content -> content.method_62839(livingEntity, 1.0f)));
                Object object = implicits$.MODULE$.catsSyntaxGroup((Object)new GenericUnit(content.amount()), GenericUnit$.MODULE$.groupGenericUnit()).$bar$minus$bar((Object)new GenericUnit(GenericUnit$.MODULE$.ONE_BOTTLE()));
                Tank<FluidLike> newTank = tank.copy(content.setAmount(object == null ? null : ((GenericUnit)object).value()), tank.copy$default$2());
                this.saveTank(stack, newTank);
                return stack;
            }
        }
        return stack;
    }

    public void method_67187(class_1799 stack, class_1792.class_9635 context, class_10712 tooltipDisplay, Consumer<class_2561> tooltip, class_1836 isAdvanced) {
        super.method_67187(stack, context, tooltipDisplay, tooltip, isAdvanced);
        Tank<FluidLike> tank = this.getTank(stack);
        if (tank.isEmpty()) {
            tooltip.accept((class_2561)class_2561.method_43469((String)"fluidtank.waila.capacity", (Object[])new Object[]{GenericUnit$.MODULE$.asForgeFromBigInt(this.tier().getCapacity())}));
            return;
        }
        GenericAmount<FluidLike> fluid = tank.content();
        BigInt capacity = tank.capacity();
        tooltip.accept((class_2561)class_2561.method_43469((String)"fluidtank.waila.short", (Object[])new Object[]{PlatformFluidAccess.getInstance().getDisplayName(fluid), BoxesRunTime.boxToLong((long)GenericUnit$.MODULE$.asDisplay$extension(fluid.amount())), BoxesRunTime.boxToLong((long)GenericUnit$.MODULE$.asDisplay$extension(capacity))}));
    }

    public Tank<FluidLike> getTank(class_1799 stack) {
        return (Tank)stack.method_58695(PlatformItemAccess.getInstance().fluidTankComponentType(), Tank$.MODULE$.apply(FluidAmountUtil$.MODULE$.EMPTY(), GenericUnit$.MODULE$.apply(this.tier().getCapacity())));
    }

    public void saveTank(class_1799 stack, Tank<FluidLike> tank) {
        if (tank.isEmpty()) {
            stack.method_57381(PlatformItemAccess.getInstance().fluidTankComponentType());
            return;
        }
        stack.method_57379(PlatformItemAccess.getInstance().fluidTankComponentType(), tank);
    }

    private class_1269 fillOrDrainFluidInLevel(class_3965 hitResult, class_1799 stack, class_1937 level, class_1657 player, GenericAmount<FluidLike> content, class_1268 hand) {
        class_2338 hitPos = hitResult.method_17777();
        class_2350 hitFace = hitResult.method_17780();
        if (level.method_8505((class_1297)player, hitPos) && player.method_7343(hitPos.method_10093(hitFace), hitFace, stack)) {
            class_2680 blockState = level.method_8320(hitPos);
            GenericAmount<FluidLike> simulateFluid = FluidAmountUtil$.MODULE$.from(level.method_8316(hitPos).method_15772(), GenericUnit$.MODULE$.ONE_BUCKET());
            class_2248 class_22482 = blockState.method_26204();
            if (class_22482 instanceof class_2263) {
                class_2263 class_22632 = (class_2263)class_22482;
                class_2248 pickUp = (class_2248)class_22632;
                if (content.isEmpty() || content.contentEqual(simulateFluid)) {
                    PlatformFluidAccess.TransferStack simulation = PlatformFluidAccess.getInstance().fillItem(simulateFluid, stack, player, hand, false);
                    if (simulation.moved().nonEmpty()) {
                        class_1799 picked = ((class_2263)pickUp).method_9700(null, (class_1936)level, hitPos, blockState);
                        GenericAmount<FluidLike> actualFluid = PlatformFluidAccess.getInstance().getFluidContained(picked);
                        PlatformFluidAccess.TransferStack result = PlatformFluidAccess.getInstance().fillItem(actualFluid, stack, player, hand, true);
                        return class_1269.field_52422.method_61393(result.toReplace());
                    }
                    return class_1269.field_5811;
                }
            }
            return class_1269.field_5811;
        }
        return class_1269.field_5814;
    }
}

