/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;
import net.pitan76.mcpitanlib.api.recipe.CompatRecipeType;
import net.pitan76.mcpitanlib.api.recipe.MatchGetter;
import net.pitan76.mcpitanlib.api.recipe.input.CompatRecipeInput;
import net.pitan76.mcpitanlib.api.recipe.v2.CompatRecipeEntry;
import net.pitan76.mcpitanlib.api.recipe.v2.CompatRecipeNonEntry;
import net.pitan76.mcpitanlib.api.registry.CompatRegistryLookup;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.IdentifierUtil;
import net.pitan76.mcpitanlib.api.util.IngredientUtil;
import net.pitan76.mcpitanlib.api.util.ItemStackUtil;
import net.pitan76.mcpitanlib.api.util.RegistryLookupUtil;
import net.pitan76.mcpitanlib.api.util.collection.ItemStackList;

public class RecipeUtil {
    public static ShapelessRecipe createShapelessRecipe(ResourceLocation id, String group, CompatibilityCraftingRecipeCategory category, ItemStack output, NonNullList<Ingredient> input) {
        return new ShapelessRecipe(group, CraftingBookCategory.valueOf((String)category.name()), output, input);
    }

    public static ShapelessRecipe createShapelessRecipe(ResourceLocation id, String group, ItemStack output, NonNullList<Ingredient> input) {
        return RecipeUtil.createShapelessRecipe(id, group, CompatibilityCraftingRecipeCategory.MISC, output, input);
    }

    @Deprecated
    public static <C extends RecipeInput> ItemStack craft_2(Recipe<C> recipe, C inventory, Level world) {
        return recipe.assemble(inventory, (HolderLookup.Provider)world.registryAccess());
    }

    @Deprecated
    public static <C extends RecipeInput> ItemStack getOutput_2(Recipe<C> recipe, Level world) {
        return recipe.getResultItem((HolderLookup.Provider)world.registryAccess());
    }

    public static ItemStack craft(Recipe<?> recipe, Container inventory, Level world) {
        if (inventory instanceof RecipeInput) {
            Recipe<?> inputRecipe = recipe;
            return inputRecipe.assemble((RecipeInput)inventory, (HolderLookup.Provider)world.registryAccess());
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack getOutput(Recipe<?> recipe, Level world) {
        return RecipeUtil.getOutput(recipe, RegistryLookupUtil.getRegistryLookup(world));
    }

    public static List<Recipe<?>> getAllRecipes(Level world) {
        Collection recipes = RecipeUtil.getRecipeManager(world).getRecipes();
        ArrayList outRecipes = new ArrayList();
        for (Object recipeEntryObj : recipes) {
            RecipeHolder recipeEntry;
            if (!(recipeEntryObj instanceof RecipeHolder) || !((recipeEntry = (RecipeHolder)recipeEntryObj).value() instanceof Recipe)) continue;
            outRecipes.add(recipeEntry.value());
        }
        return outRecipes;
    }

    public static List<CompatRecipeNonEntry<?>> getAllCompatRecipeEntry(Level world) {
        List<Recipe<?>> recipes = RecipeUtil.getAllRecipes(world);
        ArrayList outRecipes = new ArrayList();
        for (Recipe<?> recipe : recipes) {
            outRecipes.add(new CompatRecipeNonEntry(recipe));
        }
        return outRecipes;
    }

    public static RecipeType<?> getType(Recipe<?> recipe) {
        return recipe.getType();
    }

    public static ResourceLocation getId(Recipe<?> recipe) {
        return IdentifierUtil.id("" + recipe.getClass().hashCode());
    }

    public static <I extends RecipeInput, T extends Recipe<I>> CompatRecipeEntry<T> getFirstMatch(RecipeManager recipeManager, CompatRecipeType<T> type, CompatRecipeInput<I> input, Level world) {
        Optional recipe = recipeManager.getRecipeFor(type.getType(), input.getInput(), world);
        return recipe.map(CompatRecipeEntry::new).orElseGet(() -> new CompatRecipeEntry(null));
    }

    public static <I extends RecipeInput, T extends Recipe<I>> CompatRecipeEntry<T> getFirstMatch(RecipeManager recipeManager, CompatRecipeType<T> type, CompatRecipeInput<I> input, Level world, CompatIdentifier identifier) {
        Optional recipe = recipeManager.getRecipeFor(type.getType(), input.getInput(), world, identifier.toMinecraft());
        return recipe.map(CompatRecipeEntry::new).orElseGet(() -> new CompatRecipeEntry(null));
    }

    public static <I extends RecipeInput, T extends Recipe<I>> CompatRecipeEntry<T> getFirstMatch(Level world, CompatRecipeType<T> type, CompatRecipeInput<I> input) {
        return RecipeUtil.getFirstMatch(RecipeUtil.getRecipeManager(world), type, input, world);
    }

    public static <I extends RecipeInput, T extends Recipe<I>> CompatRecipeEntry<T> getFirstMatch(Level world, CompatRecipeType<T> type, CompatRecipeInput<I> input, CompatIdentifier identifier) {
        return RecipeUtil.getFirstMatch(RecipeUtil.getRecipeManager(world), type, input, world, identifier);
    }

    public static RecipeManager getRecipeManager(Level world) {
        return world.getRecipeManager();
    }

    public Optional<RecipeHolder<?>> get(Level world, CompatIdentifier id) {
        return this.get(RecipeUtil.getRecipeManager(world), id);
    }

    public Optional<RecipeHolder<?>> get(RecipeManager recipeManager, CompatIdentifier id) {
        return recipeManager.byKey(id.toMinecraft());
    }

    public static <I extends RecipeInput, T extends Recipe<I>> MatchGetter<I, T> createCachedMatchGetter(RecipeType<T> type) {
        return (input, world) -> {
            Optional optional = RecipeManager.createCheck((RecipeType)type).getRecipeFor(input.getInput(), world);
            return optional.map(CompatRecipeEntry::new);
        };
    }

    public static <I extends RecipeInput, T extends Recipe<I>> MatchGetter<I, T> createCachedMatchGetter(CompatRecipeType<T> type) {
        return RecipeUtil.createCachedMatchGetter(type.getType());
    }

    public static NonNullList<Ingredient> getInputs(Recipe<?> recipe) {
        return recipe.getIngredients();
    }

    public static NonNullList<Ingredient> getInputs(CompatRecipeEntry<?> recipeEntry) {
        return RecipeUtil.getInputs(recipeEntry.getRecipe());
    }

    public static ItemStackList getInputsAsStack(Recipe<?> recipe) {
        NonNullList<Ingredient> ingredients = RecipeUtil.getInputs(recipe);
        ItemStackList stacks = ItemStackList.ofSize(ingredients.size(), ItemStackUtil.empty());
        for (Ingredient ingredient : ingredients) {
            stacks.addAll(IngredientUtil.getMatchingStacksAsList(ingredient));
        }
        return stacks;
    }

    public static ItemStackList getInputsAsStack(CompatRecipeEntry<?> recipeEntry) {
        return RecipeUtil.getInputsAsStack(recipeEntry.getRecipe());
    }

    public static ItemStack getOutput(Recipe<?> recipe, CompatRegistryLookup registryLookup) {
        return recipe.getResultItem(registryLookup.getRegistryLookup());
    }

    public static ItemStack getOutput(CompatRecipeEntry<?> recipeEntry, CompatRegistryLookup registryLookup) {
        return RecipeUtil.getOutput(recipeEntry.getRecipe(), registryLookup);
    }

    public static CompatRecipeType<?> getType(CompatRecipeEntry<?> recipeEntry) {
        return CompatRecipeType.of(recipeEntry.getRecipe().getType());
    }

    public static <I extends RecipeInput, T extends Recipe<I>> ItemStackList getRemainder(CompatRecipeEntry<T> recipeEntry, CompatRecipeInput<I> input) {
        return ItemStackList.of((NonNullList<ItemStack>)recipeEntry.getRecipe().getRemainingItems(input.getInput()));
    }

    public static enum CompatibilityCraftingRecipeCategory {
        BUILDING,
        REDSTONE,
        EQUIPMENT,
        MISC;

    }
}

