/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.block.v2;

import com.mojang.serialization.Codec;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.pitan76.mcpitanlib.api.block.CompatibleMaterial;
import net.pitan76.mcpitanlib.api.sound.CompatBlockSoundGroup;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.color.CompatDyeColor;
import net.pitan76.mcpitanlib.api.util.color.CompatMapColor;

public class CompatibleBlockSettings
extends net.pitan76.mcpitanlib.api.block.CompatibleBlockSettings {
    protected CompatIdentifier identifier = null;
    public boolean changedTranslationKey = false;
    public static final Codec<CompatibleBlockSettings> CODEC = Codec.unit(CompatibleBlockSettings::new);

    @Deprecated
    protected CompatibleBlockSettings() {
    }

    public CompatibleBlockSettings(CompatIdentifier identifier) {
        this.setId(identifier);
    }

    public static CompatibleBlockSettings of(CompatIdentifier id) {
        return new CompatibleBlockSettings(id);
    }

    @Deprecated
    public CompatibleBlockSettings setId(CompatIdentifier identifier) {
        this.identifier = identifier;
        return this;
    }

    private static CompatibleBlockSettings copy(CompatibleMaterial material, CompatibleBlockSettings settings) {
        settings.mapColor(material.getColor());
        if (material.isLiquid()) {
            settings.settings.m_278788_();
        }
        if (material.isSolid()) {
            settings.settings.m_280606_();
        }
        if (material.isReplaceable()) {
            settings.settings.m_280170_();
        }
        if (material.isSolid()) {
            settings.settings.m_280606_();
        }
        if (material.isBurnable()) {
            settings.settings.m_278183_();
        }
        settings.settings.m_278166_(material.getPistonBehavior());
        return settings;
    }

    public CompatibleBlockSettings(CompatIdentifier id, CompatibleMaterial material, MapColor mapColor) {
        this(id);
        CompatibleBlockSettings.copy(material, this);
        this.mapColor(mapColor);
    }

    public CompatibleBlockSettings(CompatIdentifier id, CompatibleMaterial material, DyeColor dyeColor) {
        this(id);
        CompatibleBlockSettings.copy(material, this);
        this.mapColor(dyeColor);
    }

    public CompatibleBlockSettings(CompatIdentifier id, CompatibleMaterial material) {
        this(id);
        CompatibleBlockSettings.copy(material, this);
    }

    public CompatibleBlockSettings(CompatIdentifier id, CompatibleMaterial material, Function<BlockState, MapColor> mapColor) {
        this(id);
        CompatibleBlockSettings.copy(material, this);
        this.mapColor((Function)mapColor);
    }

    public static CompatibleBlockSettings of(CompatIdentifier id, CompatibleMaterial material, MapColor mapColor) {
        return new CompatibleBlockSettings(id, material, mapColor);
    }

    public static CompatibleBlockSettings of(CompatIdentifier id, CompatibleMaterial material, DyeColor dyeColor) {
        return new CompatibleBlockSettings(id, material, dyeColor);
    }

    public static CompatibleBlockSettings of(CompatIdentifier id, CompatibleMaterial material) {
        return new CompatibleBlockSettings(id, material);
    }

    public static CompatibleBlockSettings of(CompatIdentifier id, CompatibleMaterial material, Function<BlockState, MapColor> mapColor) {
        return new CompatibleBlockSettings(id, material, mapColor);
    }

    public CompatibleBlockSettings(CompatIdentifier id, BlockBehaviour block) {
        super(block);
        this.setId(id);
    }

    public static CompatibleBlockSettings copy(CompatIdentifier id, BlockBehaviour block) {
        return new CompatibleBlockSettings(id, block);
    }

    @Override
    public CompatibleBlockSettings air() {
        super.air();
        return this;
    }

    @Override
    public CompatibleBlockSettings blockVision(BlockBehaviour.StatePredicate predicate) {
        super.blockVision(predicate);
        return this;
    }

    @Override
    public CompatibleBlockSettings postProcess(BlockBehaviour.StatePredicate predicate) {
        super.postProcess(predicate);
        return this;
    }

    @Override
    public CompatibleBlockSettings solidBlock(BlockBehaviour.StatePredicate predicate) {
        super.solidBlock(predicate);
        return this;
    }

    @Override
    public CompatibleBlockSettings suffocates(BlockBehaviour.StatePredicate predicate) {
        super.suffocates(predicate);
        return this;
    }

    @Override
    public CompatibleBlockSettings mapColor(MapColor color) {
        super.mapColor(color);
        return this;
    }

    @Override
    public CompatibleBlockSettings mapColor(DyeColor color) {
        super.mapColor(color);
        return this;
    }

    public CompatibleBlockSettings mapColor(CompatMapColor color) {
        super.mapColor(color.getColor());
        return this;
    }

    public CompatibleBlockSettings mapColor(CompatDyeColor color) {
        super.mapColor(color.getColor());
        return this;
    }

    @Override
    public CompatibleBlockSettings mapColor(Function<BlockState, MapColor> color) {
        super.mapColor(color);
        return this;
    }

    public CompatibleBlockSettings compatMapColor(Function<net.pitan76.mcpitanlib.midohra.block.BlockState, CompatMapColor> color) {
        super.mapColor((BlockState state) -> ((CompatMapColor)color.apply(net.pitan76.mcpitanlib.midohra.block.BlockState.of(state))).getColor());
        return this;
    }

    @Override
    @Deprecated
    public CompatibleBlockSettings dropsLike(Block source) {
        super.dropsLike(source);
        return this;
    }

    @Override
    public CompatibleBlockSettings breakInstantly() {
        super.breakInstantly();
        return this;
    }

    @Override
    public CompatibleBlockSettings dropsNothing() {
        super.dropsNothing();
        return this;
    }

    @Override
    public CompatibleBlockSettings dynamicBounds() {
        super.dynamicBounds();
        return this;
    }

    @Override
    public CompatibleBlockSettings hardness(float hardness) {
        super.hardness(hardness);
        return this;
    }

    @Override
    public CompatibleBlockSettings noBlockBreakParticles() {
        super.noBlockBreakParticles();
        return this;
    }

    @Override
    public CompatibleBlockSettings requiresTool() {
        super.requiresTool();
        return this;
    }

    @Override
    public CompatibleBlockSettings noCollision() {
        super.noCollision();
        return this;
    }

    @Override
    public CompatibleBlockSettings nonOpaque() {
        super.nonOpaque();
        return this;
    }

    @Override
    public CompatibleBlockSettings resistance(float resistance) {
        super.resistance(resistance);
        return this;
    }

    @Override
    public CompatibleBlockSettings strength(float strength) {
        super.strength(strength);
        return this;
    }

    @Override
    public CompatibleBlockSettings strength(float hardness, float resistance) {
        super.strength(hardness, resistance);
        return this;
    }

    @Override
    public CompatibleBlockSettings ticksRandomly() {
        super.ticksRandomly();
        return this;
    }

    @Override
    public CompatibleBlockSettings sounds(CompatBlockSoundGroup blockSoundGroup) {
        super.sounds(blockSoundGroup);
        return this;
    }

    @Override
    public CompatibleBlockSettings luminance(ToIntFunction<BlockState> luminance) {
        super.luminance(luminance);
        return this;
    }

    @Override
    public CompatibleBlockSettings jumpVelocityMultiplier(float jumpVelocityMultiplier) {
        super.jumpVelocityMultiplier(jumpVelocityMultiplier);
        return this;
    }

    @Override
    public CompatibleBlockSettings slipperiness(float slipperiness) {
        super.slipperiness(slipperiness);
        return this;
    }

    @Override
    public CompatibleBlockSettings velocityMultiplier(float velocityMultiplier) {
        super.velocityMultiplier(velocityMultiplier);
        return this;
    }

    @Override
    public CompatibleBlockSettings emissiveLighting(BlockBehaviour.StatePredicate predicate) {
        super.emissiveLighting(predicate);
        return this;
    }

    @Override
    public CompatibleBlockSettings offset(BlockBehaviour.OffsetType offsetType) {
        super.offset(offsetType);
        return this;
    }

    @Override
    public CompatibleBlockSettings allowsSpawning(BlockBehaviour.StateArgumentPredicate<EntityType<?>> predicate) {
        super.allowsSpawning(predicate);
        return this;
    }

    @Override
    public BlockBehaviour.Properties build() {
        super.build();
        return this.settings;
    }

    @Override
    @Deprecated
    public CompatibleBlockSettings sounds(SoundType blockSoundGroup) {
        super.sounds(blockSoundGroup);
        return this;
    }
}

