/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.client.option;

import java.util.Objects;
import net.minecraft.client.KeyMapping;
import net.minecraft.network.chat.Component;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;

public class CompatKeyBinding {
    private final KeyMapping keyBinding;

    public CompatKeyBinding(KeyMapping keyBinding) {
        this.keyBinding = keyBinding;
    }

    public CompatKeyBinding(String translationKey, int defaultKeyCode, CompatIdentifier category) {
        this.keyBinding = new KeyMapping(translationKey, defaultKeyCode, "key.category." + category.getNamespace() + "." + category.getPath());
    }

    public CompatKeyBinding(String translationKey, int defaultKeyCode) {
        String[] parts = translationKey.split("\\.");
        if (!Objects.equals(parts[0], "key") || parts.length != 3) {
            throw new IllegalArgumentException("Cannot infer category from translation key: " + translationKey);
        }
        CompatIdentifier category = CompatIdentifier.of(parts[1], "main");
        this.keyBinding = new KeyMapping(translationKey, defaultKeyCode, "key.category." + category.getNamespace() + "." + category.getPath());
    }

    public String getTranslationKey() {
        return this.keyBinding.m_90865_();
    }

    public Component getBoundKeyLocalizedText() {
        return this.keyBinding.m_90863_();
    }

    public int getDefaultKeyCode() {
        return this.keyBinding.m_90861_().m_84873_();
    }

    public static CompatKeyBinding of(String translationKey, int defaultKeyCode, CompatIdentifier category) {
        return new CompatKeyBinding(translationKey, defaultKeyCode, category);
    }

    public static CompatKeyBinding of(String translationKey, int defaultKeyCode) {
        return new CompatKeyBinding(translationKey, defaultKeyCode);
    }

    public KeyMapping toMinecraft() {
        return this.keyBinding;
    }

    public KeyMapping getRaw() {
        return this.keyBinding;
    }
}

