/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.client.registry.forge;

import dev.architectury.registry.menu.MenuRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.pitan76.mcpitanlib.api.client.registry.CompatRegistryClient;

@Mod.EventBusSubscriber(modid="mcpitanlib", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class CompatRegistryClientImpl {
    public static Map<BlockColor, Block[]> blockColorProviders = new HashMap<BlockColor, Block[]>();

    public static <H extends AbstractContainerMenu, S extends Screen> void registerScreen(String modId, MenuType<? extends H> type, CompatRegistryClient.ScreenFactory<H, S> factory) {
        MenuRegistry.registerScreenFactory(type, factory::create);
    }

    public static void registerColorProviderBlock(BlockColor provider, Block ... blocks) {
        blockColorProviders.put(provider, blocks);
    }

    @SubscribeEvent
    public static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        if (blockColorProviders.isEmpty()) {
            return;
        }
        for (Map.Entry<BlockColor, Block[]> entry : blockColorProviders.entrySet()) {
            BlockColor provider = entry.getKey();
            Block[] blocks = entry.getValue();
            if (blocks == null || blocks.length == 0) {
                event.register(provider, new Block[0]);
                continue;
            }
            event.register(provider, blocks);
        }
    }
}

