/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.item.stack;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.pitan76.mcpitanlib.api.util.NbtUtil;

public class LoreUtil {
    public static boolean hasLore(ItemStack stack) {
        return stack.m_41737_("display") != null && stack.m_41737_("display").m_128441_("Lore");
    }

    public static List<Component> getLore(ItemStack stack) {
        if (!LoreUtil.hasLore(stack)) {
            return List.of();
        }
        return NbtUtil.getList(stack.m_41737_("display"), "Lore", 8).stream().map(nbt -> {
            String str = NbtUtil.asString(nbt);
            if (str == null) {
                return Component.m_237119_();
            }
            Pattern pattern = Pattern.compile("\"text\":\"([^\"]+)\"");
            Matcher matcher = pattern.matcher(str);
            if (matcher.find()) {
                String text = matcher.group(1);
                return Component.m_130674_((String)text);
            }
            return Component.m_130674_((String)str);
        }).toList();
    }

    public static List<String> getLoreAsStringList(ItemStack stack) {
        return LoreUtil.getLore(stack).stream().map(Component::getString).toList();
    }

    public static String getLoreAsString(ItemStack stack) {
        return LoreUtil.getLoreAsStringList(stack).stream().reduce("", (a, b) -> a + "\n" + b);
    }

    public static void setLore(ItemStack stack, List<Component> lore) {
        ListTag nbtList = NbtUtil.createNbtList();
        for (Component text : lore) {
            Object str = text.getString();
            str = "{\"text\":\"" + (String)str + "\"}";
            nbtList.add((Object)NbtUtil.createString((String)str));
        }
        CompoundTag displayNbt = stack.m_41698_("display");
        displayNbt.m_128365_("Lore", (Tag)nbtList);
        stack.m_41700_("display", (Tag)displayNbt);
    }

    public static void setLoreStringList(ItemStack stack, List<String> lore) {
        LoreUtil.setLore(stack, lore.stream().map(Component::m_130674_).toList());
    }

    public static void setLore(ItemStack stack, String lore) {
        LoreUtil.setLore(stack, lore.lines().map(Component::m_130674_).toList());
    }
}

