/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.registry;

import dev.architectury.registry.level.biome.BiomeModifications;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.pitan76.mcpitanlib.api.registry.CompatRegistry;
import net.pitan76.mcpitanlib.api.registry.result.RegistryResult;

public class WorldGenRegistry {
    protected String MOD_ID;
    protected DeferredRegister<ConfiguredFeature<?, ?>> CONFIGURED_FEATURE;
    protected DeferredRegister<PlacedFeature> PLACED_FEATURE;

    @Deprecated
    public WorldGenRegistry(String MOD_ID) {
        this.MOD_ID = MOD_ID;
        this.CONFIGURED_FEATURE = DeferredRegister.create((String)MOD_ID, (ResourceKey)Registries.f_256911_);
        this.PLACED_FEATURE = DeferredRegister.create((String)MOD_ID, (ResourceKey)Registries.f_256988_);
    }

    public static WorldGenRegistry createRegistry(String MOD_ID) {
        return new WorldGenRegistry(MOD_ID);
    }

    public static WorldGenRegistry createRegistry(CompatRegistry registry) {
        return registry.worldGenRegistry;
    }

    public RegistryResult<ConfiguredFeature<?, ?>> registerFeature(ResourceLocation id, Supplier<ConfiguredFeature<?, ?>> supplier) {
        RegistrySupplier feature = this.CONFIGURED_FEATURE.register(id, supplier);
        return new RegistryResult(feature);
    }

    public RegistryResult<PlacedFeature> registerPlacedFeature(ResourceLocation id, Supplier<PlacedFeature> supplier) {
        RegistrySupplier feature = this.PLACED_FEATURE.register(id, supplier);
        return new RegistryResult<PlacedFeature>(feature);
    }

    public static void replaceProperties(GenerationStep.Decoration decoration, RegistrySupplier<PlacedFeature> feature) {
        BiomeModifications.replaceProperties((ctx, mutable) -> mutable.getGenerationProperties().addFeature(decoration, (Holder)feature));
    }

    public static void replaceProperties(GenerationStep.Decoration decoration, RegistryResult<PlacedFeature> feature) {
        WorldGenRegistry.replaceProperties(decoration, feature.supplier);
    }

    public static void replaceProperties(GenerationStep.Decoration decoration, PlacedFeature feature) {
        BiomeModifications.replaceProperties((ctx, mutable) -> mutable.getGenerationProperties().addFeature(decoration, Holder.m_205709_((Object)feature)));
    }

    public static void addProperties(GenerationStep.Decoration decoration, RegistrySupplier<PlacedFeature> feature) {
        BiomeModifications.addProperties((ctx, mutable) -> mutable.getGenerationProperties().addFeature(decoration, (Holder)feature));
    }

    public static void addProperties(GenerationStep.Decoration decoration, RegistryResult<PlacedFeature> feature) {
        WorldGenRegistry.addProperties(decoration, feature.supplier);
    }

    public static void addProperties(GenerationStep.Decoration decoration, PlacedFeature feature) {
        BiomeModifications.addProperties((ctx, mutable) -> mutable.getGenerationProperties().addFeature(decoration, Holder.m_205709_((Object)feature)));
    }
}

