/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.transfer.fluid.v1.forge;

import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.pitan76.mcpitanlib.api.event.nbt.ReadNbtArgs;
import net.pitan76.mcpitanlib.api.event.nbt.WriteNbtArgs;
import net.pitan76.mcpitanlib.api.transfer.fluid.v1.IFluidStorage;
import net.pitan76.mcpitanlib.api.transfer.fluid.v1.IFluidVariant;
import net.pitan76.mcpitanlib.api.transfer.fluid.v1.forge.ForgeFluidVariant;

public class ForgeFluidStorage
implements IFluidStorage {
    public final FluidTank storage;
    public Runnable onChange;

    public ForgeFluidStorage(FluidTank storage, Runnable onChange) {
        this.storage = storage;
        this.onChange = onChange;
    }

    @Override
    public long getAmount() {
        return this.storage.getFluidAmount();
    }

    @Override
    public long getCapacity() {
        return this.storage.getCapacity();
    }

    @Override
    public IFluidVariant getResource() {
        return new ForgeFluidVariant(this.storage.getFluid());
    }

    @Override
    public void setResource(IFluidVariant variant) {
        this.storage.setFluid(((ForgeFluidVariant)variant).raw);
    }

    @Override
    public boolean isResourceBlank() {
        return this.storage.isEmpty();
    }

    @Override
    public long insert(IFluidVariant variant, long maxAmount, boolean simulate) {
        FluidStack stack = ((ForgeFluidVariant)variant).raw.copy();
        stack.setAmount((int)maxAmount);
        if (simulate) {
            return this.storage.fill(stack, IFluidHandler.FluidAction.SIMULATE);
        }
        this.onChange.run();
        return this.storage.fill(stack, IFluidHandler.FluidAction.EXECUTE);
    }

    @Override
    public long extract(IFluidVariant variant, long maxAmount, boolean simulate) {
        FluidStack stack = ((ForgeFluidVariant)variant).raw.copy();
        stack.setAmount((int)maxAmount);
        if (simulate) {
            return this.storage.drain(stack, IFluidHandler.FluidAction.SIMULATE).getAmount();
        }
        this.onChange.run();
        return this.storage.drain(stack, IFluidHandler.FluidAction.EXECUTE).getAmount();
    }

    @Override
    public void writeNbt(WriteNbtArgs args) {
        this.storage.writeToNBT(args.nbt);
    }

    @Override
    public void readNbt(ReadNbtArgs args) {
        this.storage.readFromNBT(args.nbt);
    }
}

