/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.pitan76.mcpitanlib.api.event.nbt.ReadNbtArgs;
import net.pitan76.mcpitanlib.api.event.nbt.WriteNbtArgs;
import net.pitan76.mcpitanlib.api.tile.CompatBlockEntity;
import net.pitan76.mcpitanlib.api.util.BlockEntityTypeUtil;
import net.pitan76.mcpitanlib.api.util.NbtUtil;
import net.pitan76.mcpitanlib.api.util.RegistryLookupUtil;

public class BlockEntityDataUtil {
    public static CompoundTag getBlockEntityNbt(ItemStack stack) {
        if (!BlockEntityDataUtil.hasBlockEntityNbt(stack)) {
            return NbtUtil.create();
        }
        return stack.m_41737_("BlockEntityTag");
    }

    public static void setBlockEntityNbt(ItemStack stack, CompoundTag nbt) {
        stack.m_41700_("BlockEntityTag", (Tag)nbt);
    }

    public static boolean hasBlockEntityNbt(ItemStack stack) {
        if (!stack.m_41782_()) {
            return false;
        }
        return NbtUtil.has(stack.m_41783_(), "BlockEntityTag");
    }

    public static void readCompatBlockEntityNbtFromStack(ItemStack stack, CompatBlockEntity blockEntity) {
        CompoundTag nbt = BlockEntityDataUtil.getBlockEntityNbt(stack);
        blockEntity.readNbt(new ReadNbtArgs(nbt, RegistryLookupUtil.getRegistryLookup(blockEntity)));
    }

    public static void writeCompatBlockEntityNbtToStack(ItemStack stack, CompatBlockEntity blockEntity) {
        CompoundTag nbt = BlockEntityDataUtil.getBlockEntityNbt(stack);
        blockEntity.writeNbt(new WriteNbtArgs(nbt, RegistryLookupUtil.getRegistryLookup(blockEntity)));
        NbtUtil.set(nbt, "id", BlockEntityTypeUtil.toID(blockEntity.m_58903_()).toString());
        BlockEntityDataUtil.setBlockEntityNbt(stack, nbt);
    }

    public static void removeBlockEntityNbt(ItemStack stack) {
        stack.m_41749_("BlockEntityTag");
    }
}

