/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.component;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.pitan76.mcpitanlib.api.item.stack.LoreUtil;
import net.pitan76.mcpitanlib.api.util.BlockEntityDataUtil;
import net.pitan76.mcpitanlib.api.util.CustomDataUtil;
import net.pitan76.mcpitanlib.api.util.NbtUtil;
import net.pitan76.mcpitanlib.midohra.component.item.CustomNameComponentType;
import net.pitan76.mcpitanlib.midohra.component.item.ItemComponentType;
import net.pitan76.mcpitanlib.midohra.component.item.RarityComponentType;

public class ItemComponentTypes {
    public static final ItemComponentType<CompoundTag> CUSTOM_DATA = new ItemComponentType<CompoundTag>("components.minecraft:custom_data"){

        @Override
        public void put(ItemStack stack, CompoundTag value) {
            CustomDataUtil.setNbt(stack, value);
        }

        @Override
        public CompoundTag get(ItemStack stack) {
            return CustomDataUtil.getNbt(stack);
        }

        @Override
        public boolean has(ItemStack stack) {
            return CustomDataUtil.hasNbt(stack);
        }
    };
    public static final ItemComponentType<Integer> MAX_STACK_SIZE = new ItemComponentType<Integer>("components.minecraft:max_stack_size"){

        @Override
        public void put(ItemStack stack, Integer value) {
        }

        @Override
        public boolean has(ItemStack stack) {
            return false;
        }

        @Override
        public Integer get(ItemStack stack) {
            return stack.m_41741_();
        }
    };
    public static final ItemComponentType<Integer> MAX_DAMAGE = new ItemComponentType<Integer>("components.minecraft:max_damage"){

        @Override
        public void put(ItemStack stack, Integer value) {
        }

        @Override
        public boolean has(ItemStack stack) {
            return false;
        }

        @Override
        public Integer get(ItemStack stack) {
            return stack.m_41776_();
        }
    };
    public static final ItemComponentType<Integer> DAMAGE = new ItemComponentType<Integer>("Damage"){

        @Override
        public void put(ItemStack stack, Integer value) {
            stack.m_41721_(value.intValue());
        }

        @Override
        public boolean has(ItemStack stack) {
            return stack.m_41782_() && NbtUtil.has(stack.m_41783_(), "Damage");
        }

        @Override
        public Integer get(ItemStack stack) {
            return stack.m_41773_();
        }
    };
    public static final ItemComponentType<Boolean> UNBREAKABLE = new ItemComponentType<Boolean>("Unbreakable"){

        @Override
        public void put(ItemStack stack, Boolean value) {
            if (value.booleanValue()) {
                stack.m_41783_().m_128379_("Unbreakable", true);
            } else {
                stack.m_41749_("Unbreakable");
            }
        }

        @Override
        public Boolean get(ItemStack stack) {
            return this.has(stack);
        }
    };
    public static final ItemComponentType<Rarity> RARITY = new RarityComponentType();
    public static final CustomNameComponentType CUSTOM_NAME = new CustomNameComponentType();
    public static final ItemComponentType<CompoundTag> BLOCK_ENTITY_DATA = new ItemComponentType<CompoundTag>("BlockEntityTag"){

        @Override
        public void put(ItemStack stack, CompoundTag value) {
            BlockEntityDataUtil.setBlockEntityNbt(stack, value);
        }

        @Override
        public boolean has(ItemStack stack) {
            return BlockEntityDataUtil.hasBlockEntityNbt(stack);
        }

        @Override
        public CompoundTag get(ItemStack stack) {
            return BlockEntityDataUtil.getBlockEntityNbt(stack);
        }
    };
    public static final ItemComponentType<CompoundTag> ENTITY_DATA = new ItemComponentType<CompoundTag>("EntityTag"){

        @Override
        public void put(ItemStack stack, CompoundTag value) {
            stack.m_41700_("EntityTag", (Tag)value);
        }

        @Override
        public boolean has(ItemStack stack) {
            return stack.m_41782_() && NbtUtil.has(stack.m_41783_(), "EntityTag");
        }

        @Override
        public CompoundTag get(ItemStack stack) {
            return stack.m_41737_("EntityTag");
        }
    };
    public static final ItemComponentType<List<Component>> LORE = new ItemComponentType<List<Component>>("display.Lore"){

        @Override
        public void put(ItemStack stack, List<Component> value) {
            LoreUtil.setLore(stack, value);
        }

        @Override
        public boolean has(ItemStack stack) {
            return LoreUtil.hasLore(stack);
        }

        @Override
        public List<Component> get(ItemStack stack) {
            return LoreUtil.getLore(stack);
        }
    };
}

