/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.world;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.pitan76.mcpitanlib.api.util.world.WorldAccessUtil;
import net.pitan76.mcpitanlib.midohra.block.entity.BlockEntityWrapper;
import net.pitan76.mcpitanlib.midohra.world.IWorldView;
import net.pitan76.mcpitanlib.midohra.world.RedstoneView;

public class WorldView
implements IWorldView,
RedstoneView {
    private final LevelReader world;

    protected WorldView(LevelReader world) {
        this.world = world;
    }

    public static WorldView of(LevelReader world) {
        return new WorldView(world);
    }

    protected LevelReader getRaw() {
        return this.world;
    }

    public LevelReader toMinecraft() {
        return this.getRaw();
    }

    public boolean isClient() {
        return WorldAccessUtil.isClient(this.getRaw());
    }

    public boolean isServer() {
        return !this.isClient();
    }

    @Override
    public BlockEntityWrapper getBlockEntity(net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos) {
        return BlockEntityWrapper.of(WorldAccessUtil.getBlockEntity(this.getRaw(), pos.toMinecraft()));
    }

    public <T extends BlockEntity> Optional<T> getRawBlockEntity(net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos, BlockEntityType<T> type) {
        return WorldAccessUtil.getBlockEntity(this.getRaw(), pos.toMinecraft(), type);
    }

    public <T extends BlockEntity> BlockEntityWrapper getBlockEntity(net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos, BlockEntityType<T> type) {
        Optional<BlockEntity> blockEntity = WorldAccessUtil.getBlockEntity(this.getRaw(), pos.toMinecraft(), type);
        return blockEntity.map(BlockEntityWrapper::of).orElse(BlockEntityWrapper.of());
    }

    @Override
    public BlockEntity getBlockEntity(BlockPos pos) {
        return this.getRaw().m_7702_(pos);
    }

    @Override
    public BlockState getBlockState(BlockPos pos) {
        return this.getRaw().m_8055_(pos);
    }

    @Override
    public FluidState getFluidState(BlockPos pos) {
        return this.getRaw().m_6425_(pos);
    }

    @Override
    @Deprecated
    public SignalGetter getRedstoneView() {
        return this.getRaw();
    }
}

