/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.networking;

import java.util.List;
import me.shedaniel.architectury.networking.NetworkManager;
import me.shedaniel.architectury.networking.transformers.PacketSink;
import me.shedaniel.architectury.networking.transformers.PacketTransformer;
import me.shedaniel.architectury.utils.Env;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class NetworkManager {
    public static void registerReceiver(Side side, class_2960 id, NetworkReceiver receiver) {
        me.shedaniel.architectury.networking.NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.sideConvert(side), (class_2960)id, (buf, context) -> receiver.receive(buf, NetworkManager.contextConvert(context)));
    }

    @ApiStatus.Experimental
    public static void registerReceiver(Side side, class_2960 id, List<PacketTransformer> packetTransformers, NetworkReceiver receiver) {
        me.shedaniel.architectury.networking.NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.sideConvert(side), (class_2960)id, packetTransformers, (buf, context) -> receiver.receive(buf, NetworkManager.contextConvert(context)));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static class_2596<?> toPacket(Side side, class_2960 id, class_2540 buf) {
        return me.shedaniel.architectury.networking.NetworkManager.toPacket((NetworkManager.Side)NetworkManager.sideConvert(side), (class_2960)id, (class_2540)buf);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static List<class_2596<?>> toPackets(Side side, class_2960 id, class_2540 buf) {
        return me.shedaniel.architectury.networking.NetworkManager.toPackets((NetworkManager.Side)NetworkManager.sideConvert(side), (class_2960)id, (class_2540)buf);
    }

    public static void collectPackets(PacketSink sink, Side side, class_2960 id, class_2540 buf) {
        me.shedaniel.architectury.networking.NetworkManager.collectPackets((PacketSink)sink, (NetworkManager.Side)NetworkManager.sideConvert(side), (class_2960)id, (class_2540)buf);
    }

    public static void sendToPlayer(class_3222 player, class_2960 id, class_2540 buf) {
        me.shedaniel.architectury.networking.NetworkManager.sendToPlayer((class_3222)player, (class_2960)id, (class_2540)buf);
    }

    public static void sendToPlayers(Iterable<class_3222> players, class_2960 id, class_2540 buf) {
        me.shedaniel.architectury.networking.NetworkManager.sendToPlayers(players, (class_2960)id, (class_2540)buf);
    }

    @Environment(value=EnvType.CLIENT)
    public static void sendToServer(class_2960 id, class_2540 buf) {
        me.shedaniel.architectury.networking.NetworkManager.sendToServer((class_2960)id, (class_2540)buf);
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean canServerReceive(class_2960 id) {
        return me.shedaniel.architectury.networking.NetworkManager.canServerReceive((class_2960)id);
    }

    public static boolean canPlayerReceive(class_3222 player, class_2960 id) {
        return me.shedaniel.architectury.networking.NetworkManager.canPlayerReceive((class_3222)player, (class_2960)id);
    }

    public static class_2596<?> createAddEntityPacket(class_1297 entity) {
        return me.shedaniel.architectury.networking.NetworkManager.createAddEntityPacket((class_1297)entity);
    }

    public static Side s2c() {
        return Side.S2C;
    }

    public static Side c2s() {
        return Side.C2S;
    }

    public static Side serverToClient() {
        return Side.S2C;
    }

    public static Side clientToServer() {
        return Side.C2S;
    }

    @Nullable
    private static NetworkManager.Side sideConvert(Side side) {
        switch (side.ordinal()) {
            case 0: {
                return NetworkManager.Side.S2C;
            }
            case 1: {
                return NetworkManager.Side.C2S;
            }
        }
        return null;
    }

    private static PacketContext contextConvert(final NetworkManager.PacketContext context) {
        return new PacketContext(){

            @Override
            public class_1657 getPlayer() {
                return context.getPlayer();
            }

            @Override
            public void queue(Runnable runnable) {
                context.queue(runnable);
            }

            @Override
            public Env getEnvironment() {
                return context.getEnvironment();
            }
        };
    }

    public static enum Side {
        S2C,
        C2S;

    }

    @FunctionalInterface
    public static interface NetworkReceiver {
        public void receive(class_2540 var1, PacketContext var2);
    }

    public static interface PacketContext {
        public class_1657 getPlayer();

        public void queue(Runnable var1);

        public Env getEnvironment();

        default public EnvType getEnv() {
            return this.getEnvironment().toPlatform();
        }
    }
}

