/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.easyapi;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;

public class FileControl {
    public static boolean fileWriteContents(String pathName, String contents) {
        return FileControl.fileWriteContents(new File(pathName), contents);
    }

    public static String fileReadContents(String pathName) {
        return FileControl.fileReadContents(new File(pathName));
    }

    public static boolean fileCopy(String inPathName, String outPathName) {
        return FileControl.fileCopy(new File(inPathName), new File(outPathName));
    }

    public static boolean fileExists(String pathName) {
        return FileControl.fileExists(new File(pathName));
    }

    public static long getFileTime(String pathName) {
        return FileControl.getFileTime(new File(pathName));
    }

    public static boolean setFileTime(String pathName, long time) {
        return FileControl.setFileTime(new File(pathName), time);
    }

    public static boolean fileRename(String pathName, String renamedPathName) {
        return FileControl.fileRename(new File(pathName), new File(renamedPathName));
    }

    public static String basename(String pathName) {
        return FileControl.basename(new File(pathName));
    }

    public static String dirname(String pathName) {
        return FileControl.dirname(new File(pathName));
    }

    public static String dirname(String pathName, int levels) {
        return FileControl.dirname(new File(pathName), levels);
    }

    public static boolean fileWriteContents(File file, String contents) {
        try {
            PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8")));
            writer.println(contents);
            writer.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String fileReadContents(File file) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            String line = "";
            String contents = "";
            while ((line = reader.readLine()) != null) {
                contents = contents + line + "\n";
            }
            reader.close();
            return contents;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean fileCopy(File inFile, File outFile) {
        try {
            FileChannel outCh = null;
            FileInputStream inStream = new FileInputStream(inFile);
            FileOutputStream outStream = new FileOutputStream(outFile);
            FileChannel inCh = inStream.getChannel();
            outCh = outStream.getChannel();
            outCh.transferFrom(inCh, 0L, inCh.size());
            inCh.close();
            outCh.close();
            inStream.close();
            outStream.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean fileExists(File file) {
        return file.exists();
    }

    public static long getFileTime(File file) {
        return file.lastModified();
    }

    public static boolean setFileTime(File file, long time) {
        return file.setLastModified(time);
    }

    public static boolean fileRename(File file, File renamedFile) {
        return file.renameTo(renamedFile);
    }

    public static File stringToFile(String pathName) {
        return new File(pathName);
    }

    public static String basename(File file) {
        return file.getName();
    }

    public static String dirname(File file) {
        return file.getParent();
    }

    public static String dirname(File file, int levels) {
        for (int i = 0; i < levels; ++i) {
            file = FileControl.dirfile(file);
        }
        return file.toString();
    }

    public static File dirfile(File file) {
        return file.getParentFile();
    }

    public static File dirfile(File file, int count) {
        for (int i = 0; i > count; ++i) {
            file = FileControl.dirfile(file);
        }
        return file;
    }
}

