/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.extra.transfer.util;

import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.base.SingleFluidStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.pitan76.mcpitanlib.api.event.nbt.NbtRWArgs;
import net.pitan76.mcpitanlib.api.registry.CompatRegistryLookup;

public class FluidStorageUtil {
    public static SingleFluidStorage withFixedCapacity(final long capacity, final Runnable onChange) {
        return new SingleFluidStorage(){

            protected long getCapacity(FluidVariant fluidVariant) {
                return capacity;
            }

            protected void markDirty() {
                onChange.run();
            }
        };
    }

    public static void readNbt(SingleFluidStorage storage, NbtRWArgs args) {
        storage.fluidVariant.getNbt().method_10543(args.nbt);
    }

    public static void writeNbt(SingleFluidStorage storage, NbtRWArgs args) {
        args.nbt.method_10543(storage.fluidVariant.getNbt());
    }

    public static void readNbt(SingleFluidStorage storage, class_2487 nbt, CompatRegistryLookup registryLookup) {
        FluidStorageUtil.readNbt(storage, new NbtRWArgs(nbt, registryLookup));
    }

    public static void writeNbt(SingleFluidStorage storage, class_2487 nbt, CompatRegistryLookup registryLookup) {
        FluidStorageUtil.writeNbt(storage, new NbtRWArgs(nbt, registryLookup));
    }

    @Deprecated
    public static void readNbt(SingleFluidStorage storage, class_2487 nbt, class_1937 world) {
        storage.fluidVariant.getNbt().method_10543(nbt);
    }

    @Deprecated
    public static void writeNbt(SingleFluidStorage storage, class_2487 nbt, class_1937 world) {
        nbt.method_10543(storage.fluidVariant.getNbt());
    }

    public static long getAmount(SingleFluidStorage storage) {
        return storage.getAmount();
    }

    public static long getCapacity(SingleFluidStorage storage) {
        return storage.getCapacity();
    }

    public static FluidVariant getResource(SingleFluidStorage storage) {
        return storage.getResource();
    }

    public static boolean isResourceBlank(SingleFluidStorage storage) {
        return storage.isResourceBlank();
    }

    public static long insert(SingleFluidStorage storage, FluidVariant insertedVariant, long maxAmount, Transaction transaction) {
        return storage.insert(insertedVariant, maxAmount, (TransactionContext)transaction);
    }

    public static long extract(SingleFluidStorage storage, FluidVariant extractedVariant, long maxAmount, Transaction transaction) {
        return storage.extract(extractedVariant, maxAmount, (TransactionContext)transaction);
    }

    public static void insert(SingleFluidStorage storage, class_3610 fluidState, long maxAmount) {
        try (Transaction transaction = Transaction.openOuter();){
            FluidStorageUtil.insert(storage, FluidVariant.of((class_3611)fluidState.method_15772()), maxAmount, transaction);
            transaction.commit();
        }
    }

    public static void extract(SingleFluidStorage storage, class_3610 fluidState, long maxAmount) {
        try (Transaction transaction = Transaction.openOuter();){
            FluidStorageUtil.extract(storage, FluidVariant.of((class_3611)fluidState.method_15772()), maxAmount, transaction);
            transaction.commit();
        }
    }

    public static boolean isEmpty(SingleFluidStorage storage) {
        return FluidStorageUtil.getAmount(storage) == 0L;
    }

    public static boolean isFull(SingleFluidStorage storage) {
        return FluidStorageUtil.getAmount(storage) >= FluidStorageUtil.getCapacity(storage);
    }
}

