/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.pitan76.mcpitanlib.api.util.TextUtil;

public class PacketByteUtil {
    public static class_2540 create() {
        return new class_2540(Unpooled.buffer());
    }

    public static class_2540 empty() {
        return new class_2540(Unpooled.EMPTY_BUFFER);
    }

    public static <K, V> Map<K, V> readMap(class_2540 buf, Function<class_2540, K> keyParser, Function<class_2540, V> valueParser) {
        class_2487 nbt = buf.method_30617();
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (String key_v : Objects.requireNonNull(nbt).method_10541()) {
            Object k;
            Object v;
            if (key_v.endsWith("_t") || key_v.endsWith("_k")) continue;
            String key = key_v.substring(0, key_v.length() - 2);
            String key_t = key + "_t";
            key_v = key + "_v";
            switch (key_t) {
                case "int": {
                    v = nbt.method_10550(key_v);
                    break;
                }
                case "str": {
                    v = nbt.method_10558(key_v);
                    break;
                }
                case "short": {
                    v = nbt.method_10568(key_v);
                    break;
                }
                case "long": {
                    v = nbt.method_10537(key_v);
                    break;
                }
                case "float": {
                    v = Float.valueOf(nbt.method_10583(key_v));
                    break;
                }
                case "byte": {
                    v = nbt.method_10571(key_v);
                    break;
                }
                case "double": {
                    v = nbt.method_10574(key_v);
                    break;
                }
                case "bool": {
                    v = nbt.method_10577(key_v);
                    break;
                }
                case "uuid": {
                    v = nbt.method_25926(key_v);
                    break;
                }
                case "text": {
                    v = TextUtil.literal(nbt.method_10558(key_v));
                    break;
                }
                case "itemstack": {
                    v = class_1799.method_7915((class_2487)nbt.method_10562(key_v));
                    break;
                }
                case "identifier": {
                    v = new class_2960(nbt.method_10558(key_v));
                    break;
                }
                case "map": {
                    v = key_v;
                    break;
                }
                default: {
                    v = null;
                }
            }
            switch (nbt.method_10558("type_k")) {
                case "int": {
                    k = Integer.valueOf(key);
                    break;
                }
                case "str": {
                    k = key;
                    break;
                }
                case "short": {
                    k = Short.valueOf(key);
                    break;
                }
                case "long": {
                    k = Long.valueOf(key);
                    break;
                }
                case "float": {
                    k = Float.valueOf(key);
                    break;
                }
                case "byte": {
                    k = Byte.valueOf(key);
                    break;
                }
                case "double": {
                    k = Double.valueOf(key);
                    break;
                }
                case "bool": {
                    k = Boolean.valueOf(key);
                    break;
                }
                case "uuid": {
                    k = UUID.fromString(key);
                    break;
                }
                case "text": {
                    k = TextUtil.literal(key);
                    break;
                }
                case "identifier": {
                    k = new class_2960(key);
                    break;
                }
                default: {
                    k = null;
                }
            }
            if (k == null || v == null) continue;
            map.put(k, v);
        }
        return map;
    }

    public static <K, V> void writeMap(class_2540 buf, Map<K, V> map) {
        PacketByteUtil.writeMap(buf, map, PacketByteUtil::writeVar, PacketByteUtil::writeVar);
    }

    public static <K, V> void writeMap(class_2540 buf, Map<K, V> map, BiConsumer<class_2540, K> keySerializer, BiConsumer<class_2540, V> valueSerializer) {
        class_2487 nbt = new class_2487();
        Object lastK = null;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K k = entry.getKey();
            V v = entry.getValue();
            lastK = k;
            String key = k.toString();
            if (v instanceof Integer) {
                nbt.method_10569(key + "_v", ((Integer)v).intValue());
                nbt.method_10582(key + "_t", "int");
            }
            if (v instanceof String) {
                nbt.method_10582(key, (String)v);
                nbt.method_10582(key + "_t", "str");
            }
            if (v instanceof Long) {
                nbt.method_10544(key, ((Long)v).longValue());
                nbt.method_10582(key + "_t", "long");
            }
            if (v instanceof Short) {
                nbt.method_10575(key, ((Short)v).shortValue());
                nbt.method_10582(key + "_t", "short");
            }
            if (v instanceof Double) {
                nbt.method_10549(key, ((Double)v).doubleValue());
                nbt.method_10582(key + "_t", "double");
            }
            if (v instanceof Boolean) {
                nbt.method_10556(key, ((Boolean)v).booleanValue());
                nbt.method_10582(key + "_t", "bool");
            }
            if (v instanceof Float) {
                nbt.method_10548(key, ((Float)v).floatValue());
                nbt.method_10582(key + "_t", "float");
            }
            if (v instanceof Byte) {
                nbt.method_10567(key, ((Byte)v).byteValue());
                nbt.method_10582(key + "_t", "byte");
            }
            if (v instanceof UUID) {
                nbt.method_25927(key, (UUID)v);
                nbt.method_10582(key + "_t", "uuid");
            }
            if (v instanceof class_2561) {
                nbt.method_10582(key, ((class_2561)v).getString());
                nbt.method_10582(key + "_t", "text");
            }
            if (v instanceof class_1799) {
                class_2487 stackNbt = new class_2487();
                ((class_1799)v).method_7953(stackNbt);
                nbt.method_10566(key, (class_2520)stackNbt);
                nbt.method_10582(key + "_t", "itemstack");
            }
            if (!(v instanceof class_2960)) continue;
            nbt.method_10582(key, v.toString());
            nbt.method_10582(key + "_t", "identifier");
        }
        if (lastK == null) {
            return;
        }
        if (lastK instanceof Integer) {
            nbt.method_10582("type_k", "int");
        }
        if (lastK instanceof String) {
            nbt.method_10582("type_k", "str");
        }
        if (lastK instanceof Long) {
            nbt.method_10582("type_k", "long");
        }
        if (lastK instanceof Short) {
            nbt.method_10582("type_k", "short");
        }
        if (lastK instanceof Double) {
            nbt.method_10582("type_k", "double");
        }
        if (lastK instanceof Boolean) {
            nbt.method_10582("type_k", "bool");
        }
        if (lastK instanceof Float) {
            nbt.method_10582("type_k", "float");
        }
        if (lastK instanceof Byte) {
            nbt.method_10582("type_k", "byte");
        }
        if (lastK instanceof UUID) {
            nbt.method_10582("type_k", "uuid");
        }
        if (lastK instanceof class_2561) {
            nbt.method_10582("type_k", "text");
        }
        if (lastK instanceof class_1799) {
            nbt.method_10582("type_k", "itemstack");
        }
        if (lastK instanceof class_2960) {
            nbt.method_10582("type_k", "identifier");
        }
        buf.method_10794(nbt);
    }

    public static void writeVar(class_2540 buf, Object obj) {
        if (obj instanceof String) {
            String s = (String)obj;
            buf.method_10814(s);
        }
        if (obj instanceof Integer) {
            int i = (Integer)obj;
            buf.writeInt(i);
        }
        if (obj instanceof Long) {
            long l = (Long)obj;
            buf.writeLong(l);
        }
        if (obj instanceof Short) {
            short s = (Short)obj;
            buf.writeShort((int)s);
        }
        if (obj instanceof Boolean) {
            boolean b = (Boolean)obj;
            buf.writeBoolean(b);
        }
        if (obj instanceof Byte) {
            byte b = (Byte)obj;
            buf.writeByte((int)b);
        }
        if (obj instanceof class_2487) {
            class_2487 nbt = (class_2487)obj;
            buf.method_10794(nbt);
        }
        if (obj instanceof class_1799) {
            class_1799 stack = (class_1799)obj;
            buf.method_10793(stack);
        }
        if (obj instanceof class_2960) {
            class_2960 identifier = (class_2960)obj;
            buf.method_10812(identifier);
        }
        if (obj instanceof Float) {
            Float f = (Float)obj;
            buf.writeFloat(f.floatValue());
        }
        if (obj instanceof UUID) {
            UUID uuid = (UUID)obj;
            buf.method_10797(uuid);
        }
        if (obj instanceof class_2561) {
            class_2561 text = (class_2561)obj;
            buf.method_10805(text);
        }
        if (obj instanceof class_2338) {
            class_2338 pos = (class_2338)obj;
            buf.method_10807(pos);
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            PacketByteUtil.writeMap(buf, map);
        }
    }

    public static class_2540 writeNbt(class_2540 buf, class_2487 nbt) {
        return buf.method_10794(nbt);
    }

    public static class_2487 readNbt(class_2540 buf) {
        return buf.method_10798();
    }

    public static class_2540 writeItemStack(class_2540 buf, class_1799 stack) {
        return buf.method_10793(stack);
    }

    public static class_1799 readItemStack(class_2540 buf) {
        return buf.method_10819();
    }

    public static class_2540 writeIdentifier(class_2540 buf, class_2960 identifier) {
        return buf.method_10812(identifier);
    }

    public static class_2960 readIdentifier(class_2540 buf) {
        return buf.method_10810();
    }

    public static class_2540 writeText(class_2540 buf, class_2561 text) {
        return buf.method_10805(text);
    }

    public static class_2561 readText(class_2540 buf) {
        return buf.method_10808();
    }

    public static class_2540 writeBlockPos(class_2540 buf, class_2338 pos) {
        return buf.method_10807(pos);
    }

    public static class_2338 readBlockPos(class_2540 buf) {
        return buf.method_10811();
    }

    public static class_2540 writeUuid(class_2540 buf, UUID uuid) {
        return buf.method_10797(uuid);
    }

    public static UUID readUuid(class_2540 buf) {
        return buf.method_10790();
    }

    public static class_2540 writeVarInt(class_2540 buf, int i) {
        return buf.method_10804(i);
    }

    public static int readVarInt(class_2540 buf) {
        return buf.method_10816();
    }

    public static class_2540 writeVarLong(class_2540 buf, long l) {
        return buf.method_10791(l);
    }

    public static long readVarLong(class_2540 buf) {
        return buf.method_10792();
    }

    public static ByteBuf writeBoolean(class_2540 buf, boolean b) {
        return buf.writeBoolean(b);
    }

    public static boolean readBoolean(class_2540 buf) {
        return buf.readBoolean();
    }

    public static ByteBuf writeByte(class_2540 buf, byte b) {
        return buf.writeByte((int)b);
    }

    public static byte readByte(class_2540 buf) {
        return buf.readByte();
    }

    public static ByteBuf writeShort(class_2540 buf, short s) {
        return buf.writeShort((int)s);
    }

    public static short readShort(class_2540 buf) {
        return buf.readShort();
    }

    public static ByteBuf writeInt(class_2540 buf, int i) {
        return buf.writeInt(i);
    }

    public static int readInt(class_2540 buf) {
        return buf.readInt();
    }

    public static ByteBuf writeLong(class_2540 buf, long l) {
        return buf.writeLong(l);
    }

    public static long readLong(class_2540 buf) {
        return buf.readLong();
    }

    public static ByteBuf writeFloat(class_2540 buf, float f) {
        return buf.writeFloat(f);
    }

    public static float readFloat(class_2540 buf) {
        return buf.readFloat();
    }

    public static ByteBuf writeDouble(class_2540 buf, double d) {
        return buf.writeDouble(d);
    }

    public static double readDouble(class_2540 buf) {
        return buf.readDouble();
    }

    public static class_2540 writeByteArray(class_2540 buf, byte[] bytes) {
        return buf.method_10813(bytes);
    }

    public static byte[] readByteArray(class_2540 buf) {
        return buf.method_10795();
    }

    public static class_2540 writeString(class_2540 buf, String s) {
        return buf.method_10814(s);
    }

    public static String readString(class_2540 buf) {
        return buf.method_19772();
    }

    public static class_2540 writeIntArray(class_2540 buf, int[] ints) {
        return buf.method_10806(ints);
    }

    public static int[] readIntArray(class_2540 buf) {
        return buf.method_10787();
    }

    public static class_2540 writeLongArray(class_2540 buf, long[] longs) {
        return buf.method_10789(longs);
    }

    public static long[] readLongArray(class_2540 buf) {
        long[] longs = new long[buf.readableBytes() / 8];
        return buf.method_10801(longs);
    }

    public static class_2520 readUnlimitedNbt(class_2540 buf) {
        return buf.method_30616(new class_2505(Long.MAX_VALUE));
    }
}

