/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.server;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_3317;
import net.minecraft.class_3324;
import net.minecraft.class_3335;
import net.minecraft.class_3337;
import net.minecraft.server.MinecraftServer;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.api.text.TextComponent;
import net.pitan76.mcpitanlib.api.util.TextUtil;
import net.pitan76.mcpitanlib.midohra.server.MCServer;
import net.pitan76.mcpitanlib.midohra.world.ServerWorld;
import net.pitan76.mcpitanlib.midohra.world.World;

public class PlayerManager {
    private final class_3324 playerManager;

    protected PlayerManager(class_3324 playerManager) {
        this.playerManager = playerManager;
    }

    public static PlayerManager of(class_3324 playerManager) {
        return new PlayerManager(playerManager);
    }

    public static PlayerManager of(MinecraftServer server) {
        return PlayerManager.of(server.method_3760());
    }

    public static PlayerManager of(MCServer server) {
        return PlayerManager.of(server.getRaw());
    }

    public static PlayerManager of(ServerWorld world) {
        return PlayerManager.of(world.getServer());
    }

    public static PlayerManager of(World world) {
        return PlayerManager.of(world.getServer());
    }

    public class_3324 getRaw() {
        return this.playerManager;
    }

    public class_3324 toMinecraft() {
        return this.getRaw();
    }

    public void broadcast(TextComponent message, boolean overlay) {
        if (overlay) {
            this.getRaw().method_14616(message.getText(), class_2556.field_11735, UUID.randomUUID());
        } else {
            this.getRaw().method_14616(message.getText(), class_2556.field_11737, UUID.randomUUID());
        }
    }

    public void broadcast(TextComponent message) {
        this.broadcast(message, false);
    }

    public void broadcast(String message, boolean overlay) {
        if (overlay) {
            this.getRaw().method_14616((class_2561)TextUtil.literal(message), class_2556.field_11735, UUID.randomUUID());
        } else {
            this.getRaw().method_14616((class_2561)TextUtil.literal(message), class_2556.field_11737, UUID.randomUUID());
        }
    }

    public void broadcast(String message) {
        this.broadcast(message, false);
    }

    public void removePlayer(Player player) {
        this.getRaw().method_14611(player.getServerPlayer().get());
    }

    public Player getPlayerByUUID(UUID uuid) {
        return new Player((class_1657)this.getRaw().method_14602(uuid));
    }

    public Player getPlayerByName(String name) {
        return new Player((class_1657)this.getRaw().method_14566(name));
    }

    public List<Player> getPlayersByIP(String ip) {
        ArrayList<Player> players = new ArrayList<Player>();
        for (class_1657 p : this.getRaw().method_14559(ip)) {
            players.add(new Player(p));
        }
        return players;
    }

    public List<Player> getPlayers() {
        ArrayList<Player> players = new ArrayList<Player>();
        for (class_1657 p : this.getRaw().method_14571()) {
            players.add(new Player(p));
        }
        return players;
    }

    public boolean isExistByUUID(UUID uuid) {
        return this.getRaw().method_14602(uuid) != null;
    }

    public boolean isExistByName(String name) {
        return this.getRaw().method_14566(name) != null;
    }

    public boolean isExistByIP(String ip) {
        return !this.getRaw().method_14559(ip).isEmpty();
    }

    public boolean hasPlayerByUUID(UUID uuid) {
        return this.getRaw().method_14602(uuid) != null;
    }

    public boolean hasPlayerByName(String name) {
        return this.getRaw().method_14566(name) != null;
    }

    public boolean hasPlayerByIP(String ip) {
        return !this.getRaw().method_14559(ip).isEmpty();
    }

    public int getCurrentPlayerCount() {
        return this.getRaw().method_14574();
    }

    public int getMaxPlayerCount() {
        return this.getRaw().method_14592();
    }

    public boolean isWhitelistEnabled() {
        return this.getRaw().method_14614();
    }

    public void setWhitelistEnabled(boolean enabled) {
        this.getRaw().method_14557(enabled);
    }

    public class_3337 getWhitelist() {
        return this.getRaw().method_14590();
    }

    public void reloadWhitelist() {
        this.getRaw().method_14599();
    }

    public class_3317 getBannedIpList() {
        return this.getRaw().method_14585();
    }

    public class_3335 getBannedPlayerList() {
        return this.getRaw().method_14563();
    }
}

