/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.block;

import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;

public final class CompatibleMaterial {
    public static final CompatibleMaterial AIR = new Builder(MaterialColor.field_151660_b).allowsMovement().lightPassesThrough().notSolid().replaceable().material(Material.field_151579_a).build();
    public static final CompatibleMaterial STRUCTURE_VOID = new Builder(MaterialColor.field_151660_b).allowsMovement().lightPassesThrough().notSolid().replaceable().material(Material.field_189963_J).build();
    public static final CompatibleMaterial PORTAL = new Builder(MaterialColor.field_151660_b).allowsMovement().lightPassesThrough().notSolid().blocksPistons().material(Material.field_151567_E).build();
    public static final CompatibleMaterial CARPET = new Builder(MaterialColor.field_151659_e).allowsMovement().lightPassesThrough().notSolid().burnable().material(Material.field_151593_r).build();
    public static final CompatibleMaterial PLANT = new Builder(MaterialColor.field_151669_i).allowsMovement().lightPassesThrough().notSolid().destroyedByPiston().material(Material.field_151585_k).build();
    public static final CompatibleMaterial UNDERWATER_PLANT = new Builder(MaterialColor.field_151662_n).allowsMovement().lightPassesThrough().notSolid().destroyedByPiston().material(Material.field_203243_f).build();
    public static final CompatibleMaterial REPLACEABLE_PLANT = new Builder(MaterialColor.field_151669_i).allowsMovement().lightPassesThrough().notSolid().destroyedByPiston().replaceable().burnable().material(Material.field_151582_l).build();
    public static final CompatibleMaterial NETHER_SHOOTS = new Builder(MaterialColor.field_151669_i).allowsMovement().lightPassesThrough().notSolid().destroyedByPiston().replaceable().material(Material.field_242934_h).build();
    public static final CompatibleMaterial REPLACEABLE_UNDERWATER_PLANT = new Builder(MaterialColor.field_151662_n).allowsMovement().lightPassesThrough().notSolid().destroyedByPiston().replaceable().material(Material.field_204868_h).build();
    public static final CompatibleMaterial WATER = new Builder(MaterialColor.field_151662_n).allowsMovement().lightPassesThrough().notSolid().destroyedByPiston().replaceable().liquid().material(Material.field_151586_h).build();
    public static final CompatibleMaterial BUBBLE_COLUMN = new Builder(MaterialColor.field_151662_n).allowsMovement().lightPassesThrough().notSolid().destroyedByPiston().replaceable().liquid().material(Material.field_203244_i).build();
    public static final CompatibleMaterial LAVA = new Builder(MaterialColor.field_151656_f).allowsMovement().lightPassesThrough().notSolid().destroyedByPiston().replaceable().liquid().material(Material.field_151587_i).build();
    public static final CompatibleMaterial SNOW_LAYER = new Builder(MaterialColor.field_151666_j).allowsMovement().lightPassesThrough().notSolid().destroyedByPiston().replaceable().material(Material.field_151597_y).build();
    public static final CompatibleMaterial FIRE = new Builder(MaterialColor.field_151660_b).allowsMovement().lightPassesThrough().notSolid().destroyedByPiston().replaceable().material(Material.field_151581_o).build();
    public static final CompatibleMaterial DECORATION = new Builder(MaterialColor.field_151660_b).allowsMovement().lightPassesThrough().notSolid().destroyedByPiston().material(Material.field_151594_q).build();
    public static final CompatibleMaterial COBWEB = new Builder(MaterialColor.field_151659_e).allowsMovement().lightPassesThrough().destroyedByPiston().material(Material.field_151569_G).build();
    public static final CompatibleMaterial SCULK = new Builder(MaterialColor.field_151646_E).build();
    public static final CompatibleMaterial REDSTONE_LAMP = new Builder(MaterialColor.field_151660_b).material(Material.field_151591_t).build();
    public static final CompatibleMaterial ORGANIC_PRODUCT = new Builder(MaterialColor.field_151667_k).material(Material.field_151571_B).build();
    public static final CompatibleMaterial SOIL = new Builder(MaterialColor.field_151664_l).material(Material.field_151578_c).build();
    public static final CompatibleMaterial SOLID_ORGANIC = new Builder(MaterialColor.field_151661_c).material(Material.field_151577_b).build();
    public static final CompatibleMaterial DENSE_ICE = new Builder(MaterialColor.field_151657_g).material(Material.field_151598_x).build();
    public static final CompatibleMaterial AGGREGATE = new Builder(MaterialColor.field_151658_d).material(Material.field_151595_p).build();
    public static final CompatibleMaterial SPONGE = new Builder(MaterialColor.field_151673_t).material(Material.field_151583_m).build();
    public static final CompatibleMaterial SHULKER_BOX = new Builder(MaterialColor.field_151678_z).material(Material.field_215711_w).build();
    public static final CompatibleMaterial WOOD = new Builder(MaterialColor.field_151663_o).burnable().material(Material.field_151575_d).build();
    public static final CompatibleMaterial NETHER_WOOD = new Builder(MaterialColor.field_151663_o).material(Material.field_237214_y_).build();
    public static final CompatibleMaterial BAMBOO_SAPLING = new Builder(MaterialColor.field_151663_o).burnable().destroyedByPiston().allowsMovement().material(Material.field_215712_y).build();
    public static final CompatibleMaterial BAMBOO = new Builder(MaterialColor.field_151663_o).burnable().destroyedByPiston().material(Material.field_215713_z).build();
    public static final CompatibleMaterial WOOL = new Builder(MaterialColor.field_151659_e).burnable().material(Material.field_151580_n).build();
    public static final CompatibleMaterial TNT = new Builder(MaterialColor.field_151656_f).burnable().lightPassesThrough().material(Material.field_151590_u).build();
    public static final CompatibleMaterial LEAVES = new Builder(MaterialColor.field_151669_i).burnable().lightPassesThrough().destroyedByPiston().material(Material.field_151584_j).build();
    public static final CompatibleMaterial GLASS = new Builder(MaterialColor.field_151660_b).lightPassesThrough().material(Material.field_151592_s).build();
    public static final CompatibleMaterial ICE = new Builder(MaterialColor.field_151657_g).lightPassesThrough().material(Material.field_151588_w).build();
    public static final CompatibleMaterial CACTUS = new Builder(MaterialColor.field_151669_i).lightPassesThrough().destroyedByPiston().material(Material.field_151570_A).build();
    public static final CompatibleMaterial STONE = new Builder(MaterialColor.field_151665_m).material(Material.field_151576_e).build();
    public static final CompatibleMaterial METAL = new Builder(MaterialColor.field_151668_h).material(Material.field_151573_f).build();
    public static final CompatibleMaterial SNOW_BLOCK = new Builder(MaterialColor.field_151666_j).material(Material.field_151596_z).build();
    public static final CompatibleMaterial REPAIR_STATION = new Builder(MaterialColor.field_151668_h).blocksPistons().material(Material.field_151574_g).build();
    public static final CompatibleMaterial BARRIER = new Builder(MaterialColor.field_151660_b).blocksPistons().material(Material.field_175972_I).build();
    public static final CompatibleMaterial PISTON = new Builder(MaterialColor.field_151665_m).blocksPistons().material(Material.field_76233_E).build();
    public static final CompatibleMaterial MOSS_BLOCK = new Builder(MaterialColor.field_151669_i).destroyedByPiston().material(Material.field_151589_v).build();
    public static final CompatibleMaterial GOURD = new Builder(MaterialColor.field_151669_i).destroyedByPiston().material(Material.field_151572_C).build();
    public static final CompatibleMaterial EGG = new Builder(MaterialColor.field_151669_i).destroyedByPiston().material(Material.field_151566_D).build();
    public static final CompatibleMaterial CAKE = new Builder(MaterialColor.field_151660_b).destroyedByPiston().material(Material.field_151568_F).build();
    public static final CompatibleMaterial AMETHYST = new Builder(MaterialColor.field_151678_z).build();
    public static final CompatibleMaterial POWDER_SNOW = new Builder(MaterialColor.field_151666_j).notSolid().allowsMovement().build();
    private final MaterialColor color;
    private final PushReaction pistonBehavior;
    private final boolean burnable;
    private final boolean liquid;
    private final boolean replaceable;
    private final boolean solid;
    private Material material;

    public CompatibleMaterial(MaterialColor color, boolean liquid, boolean solid, boolean burnable, boolean replaceable, PushReaction pistonBehavior) {
        this.color = color;
        this.liquid = liquid;
        this.solid = solid;
        this.burnable = burnable;
        this.replaceable = replaceable;
        this.pistonBehavior = pistonBehavior;
        this.material = Material.field_151576_e;
    }

    private CompatibleMaterial(Material material, MaterialColor color, boolean liquid, boolean solid, boolean burnable, boolean replaceable, PushReaction pistonBehavior) {
        this(material.func_151565_r(), material.func_76224_d(), material.func_76220_a(), material.func_76217_h(), material.func_76222_j(), material.func_186274_m());
        this.material = material;
    }

    @Deprecated
    public Material getMaterial() {
        return this.material;
    }

    public boolean isLiquid() {
        return this.liquid;
    }

    public boolean isSolid() {
        return this.solid;
    }

    public boolean isBurnable() {
        return this.burnable;
    }

    public boolean isReplaceable() {
        return this.replaceable;
    }

    public PushReaction getPistonBehavior() {
        return this.pistonBehavior;
    }

    public MaterialColor getColor() {
        return this.color;
    }

    public static class Builder {
        private PushReaction pistonBehavior;
        private boolean blocksMovement = true;
        private boolean burnable;
        private boolean liquid;
        private boolean replaceable;
        private boolean solid = true;
        private final MaterialColor color;
        private boolean blocksLight = true;
        private Material material = Material.field_151576_e;

        public Builder(MaterialColor color) {
            this.pistonBehavior = PushReaction.NORMAL;
            this.color = color;
        }

        public Builder liquid() {
            this.liquid = true;
            return this;
        }

        public Builder notSolid() {
            this.solid = false;
            return this;
        }

        public Builder allowsMovement() {
            this.blocksMovement = false;
            return this;
        }

        Builder lightPassesThrough() {
            this.blocksLight = false;
            return this;
        }

        protected Builder burnable() {
            this.burnable = true;
            return this;
        }

        public Builder replaceable() {
            this.replaceable = true;
            return this;
        }

        protected Builder destroyedByPiston() {
            this.pistonBehavior = PushReaction.DESTROY;
            return this;
        }

        protected Builder blocksPistons() {
            this.pistonBehavior = PushReaction.BLOCK;
            return this;
        }

        protected Builder material(Material material) {
            this.material = material;
            return this;
        }

        public CompatibleMaterial build() {
            return new CompatibleMaterial(this.material, this.color, this.liquid, this.solid, this.burnable, this.replaceable, this.pistonBehavior);
        }
    }
}

