/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.block.args.v2;

import net.minecraft.block.Block;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.api.event.BaseEvent;
import net.pitan76.mcpitanlib.api.event.item.ItemUseOnBlockEvent;
import net.pitan76.mcpitanlib.api.util.BlockStateUtil;
import net.pitan76.mcpitanlib.midohra.block.BlockState;
import net.pitan76.mcpitanlib.midohra.block.BlockWrapper;
import net.pitan76.mcpitanlib.midohra.block.entity.BlockEntityWrapper;
import net.pitan76.mcpitanlib.midohra.holder.BlockStatePropertyHolder;
import net.pitan76.mcpitanlib.midohra.util.hit.BlockHitResult;
import net.pitan76.mcpitanlib.midohra.util.hit.HitResultType;
import net.pitan76.mcpitanlib.midohra.util.math.Direction;
import net.pitan76.mcpitanlib.midohra.world.IWorldView;
import net.pitan76.mcpitanlib.midohra.world.World;
import net.pitan76.mcpitanlib.mixin.ItemUsageContextMixin;
import org.jetbrains.annotations.Nullable;

public class PlacementStateArgs
extends BaseEvent
implements BlockStatePropertyHolder {
    public BlockItemUseContext ctx;
    @Nullable
    public Block block;

    public PlacementStateArgs(BlockItemUseContext ctx) {
        this.ctx = ctx;
    }

    public PlacementStateArgs(BlockItemUseContext ctx, @Nullable Block block) {
        this.ctx = ctx;
        this.block = block;
    }

    public boolean canPlace() {
        return this.ctx.func_196011_b();
    }

    public BlockPos getRawPos() {
        return this.ctx.func_195995_a();
    }

    public net.pitan76.mcpitanlib.midohra.util.math.BlockPos getPos() {
        return net.pitan76.mcpitanlib.midohra.util.math.BlockPos.of(this.getRawPos());
    }

    public Player getPlayer() {
        return new Player(this.ctx.func_195999_j());
    }

    public Direction[] getPlacementDirections() {
        net.minecraft.util.Direction[] rawDirs = this.getRawPlacementDirections();
        Direction[] directions = new Direction[rawDirs.length];
        for (int i = 0; i < directions.length; ++i) {
            directions[i] = Direction.of(rawDirs[i]);
        }
        return directions;
    }

    public net.minecraft.util.Direction[] getRawPlacementDirections() {
        return this.ctx.func_196009_e();
    }

    public Hand getHand() {
        return this.ctx.func_221531_n();
    }

    public Direction getSide() {
        return Direction.of(this.getRawSide());
    }

    public net.minecraft.util.Direction getRawSide() {
        return this.ctx.func_196000_l();
    }

    public Direction getHorizontalPlayerFacing() {
        return Direction.of(this.getRawHorizontalPlayerFacing());
    }

    public net.minecraft.util.Direction getRawHorizontalPlayerFacing() {
        return this.ctx.func_195992_f();
    }

    public float getPlayerYaw() {
        return this.ctx.func_195990_h();
    }

    public World getWorld() {
        return World.of(this.ctx.func_195991_k());
    }

    public IWorldView getWorldView() {
        return this.getWorld();
    }

    public boolean isClient() {
        return this.getWorld().isClient();
    }

    public Vector3d getHitPos() {
        return this.ctx.func_221532_j();
    }

    public boolean canReplaceExisting() {
        return this.ctx.func_196012_c();
    }

    @Deprecated
    public ItemUsageContextMixin getIUCAccessor() {
        return (ItemUsageContextMixin)this.ctx;
    }

    public BlockRayTraceResult getHitResult() {
        return this.getIUCAccessor().getHit();
    }

    public ItemUseOnBlockEvent toItemUseOnBlockEvent() {
        return new ItemUseOnBlockEvent(this.getWorld().getRaw(), this.getPlayer().getPlayerEntity(), this.getHand(), this.ctx.func_195996_i(), this.getHitResult());
    }

    public BlockItemUseContext getCtx() {
        return this.ctx;
    }

    @Nullable
    public Block getRawBlock() {
        return this.block;
    }

    public boolean isBlockExist() {
        return this.block != null;
    }

    public net.minecraft.block.BlockState getRawBlockState() {
        return BlockStateUtil.getDefaultState(this.block);
    }

    public TileEntity getRawBlockEntity() {
        return this.getWorld().getBlockEntity(this.getRawPos());
    }

    public BlockWrapper getBlock() {
        return BlockWrapper.of(this.block);
    }

    public <T extends Comparable<T>, V extends T> net.minecraft.block.BlockState with(Property<T> property, V value) {
        if (this.block == null) {
            return null;
        }
        return BlockStateUtil.with(BlockStateUtil.getDefaultState(this.block), property, value);
    }

    @Override
    public BlockState getBlockState() {
        return BlockState.of(this.getRawBlockState());
    }

    public BlockEntityWrapper getBlockEntity() {
        return this.getWorld().getBlockEntity(this.getPos());
    }

    public BlockHitResult getHitResultM() {
        return BlockHitResult.of(this.getHitResult());
    }

    public HitResultType getHitResultTypeM() {
        return HitResultType.from(this.getHitResult().func_216346_c());
    }
}

