/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.client.event.forge;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.pitan76.mcpitanlib.api.client.event.listener.BeforeBlockOutlineEvent;
import net.pitan76.mcpitanlib.api.client.event.listener.BeforeBlockOutlineListener;
import net.pitan76.mcpitanlib.api.client.event.listener.WorldRenderContext;
import net.pitan76.mcpitanlib.api.client.event.listener.WorldRenderContextListener;

@Mod.EventBusSubscriber(modid="mcpitanlib", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class WorldRenderRegistryImpl {
    public static List<BeforeBlockOutlineListener> beforeBlockOutlineListeners = new ArrayList<BeforeBlockOutlineListener>();
    public static List<WorldRenderContextListener> worldRenderAfterLevelListeners = new ArrayList<WorldRenderContextListener>();

    @SubscribeEvent
    public static void renderOutlineEventBlock(final DrawHighlightEvent event) {
        for (BeforeBlockOutlineListener listener : beforeBlockOutlineListeners) {
            boolean eventContinue = listener.beforeBlockOutline(new BeforeBlockOutlineEvent(new WorldRenderContext(){

                @Override
                public WorldRenderer getWorldRenderer() {
                    return event.getContext();
                }

                @Override
                public MatrixStack getMatrixStack() {
                    return event.getMatrix();
                }

                @Override
                public float getTickDelta() {
                    return event.getPartialTicks();
                }

                @Override
                public ActiveRenderInfo getCamera() {
                    return event.getInfo();
                }

                @Override
                public GameRenderer getGameRenderer() {
                    return Minecraft.func_71410_x().field_71460_t;
                }

                @Override
                public LightTexture getLightmapTextureManager() {
                    return Minecraft.func_71410_x().field_71460_t.func_228384_l_();
                }

                @Override
                @Deprecated
                public Matrix4f getProjectionMatrix() {
                    return null;
                }

                @Override
                public ClientWorld getWorld() {
                    return Minecraft.func_71410_x().field_71441_e;
                }

                @Override
                @Deprecated
                public boolean isAdvancedTranslucency() {
                    return this.getWorldRenderer().func_184384_n();
                }

                @Override
                public IRenderTypeBuffer getConsumers() {
                    return event.getBuffers();
                }

                @Override
                public ClippingHelper getFrustum() {
                    return null;
                }
            }, event.getTarget()));
            if (eventContinue) continue;
            event.setCanceled(true);
            break;
        }
    }

    @SubscribeEvent
    public static void registerWorldRenderAfterLevel(final RenderWorldLastEvent event) {
        for (WorldRenderContextListener listener : worldRenderAfterLevelListeners) {
            listener.render(new WorldRenderContext(){

                @Override
                public WorldRenderer getWorldRenderer() {
                    return event.getContext();
                }

                @Override
                public MatrixStack getMatrixStack() {
                    return event.getMatrixStack();
                }

                @Override
                public float getTickDelta() {
                    return event.getPartialTicks();
                }

                @Override
                public ActiveRenderInfo getCamera() {
                    return this.getGameRenderer().func_215316_n();
                }

                @Override
                public GameRenderer getGameRenderer() {
                    return Minecraft.func_71410_x().field_71460_t;
                }

                @Override
                public LightTexture getLightmapTextureManager() {
                    return this.getGameRenderer().func_228384_l_();
                }

                @Override
                @Deprecated
                public Matrix4f getProjectionMatrix() {
                    return event.getProjectionMatrix();
                }

                @Override
                public ClientWorld getWorld() {
                    return Minecraft.func_71410_x().field_71441_e;
                }

                @Override
                @Deprecated
                public boolean isAdvancedTranslucency() {
                    return this.getWorldRenderer().func_184384_n();
                }

                @Override
                public IRenderTypeBuffer getConsumers() {
                    return Minecraft.func_71410_x().func_228019_au_().func_228490_d_();
                }

                @Override
                public ClippingHelper getFrustum() {
                    return null;
                }
            });
        }
    }

    public static void registerWorldRenderBeforeBlockOutline(BeforeBlockOutlineListener listener) {
        beforeBlockOutlineListeners.add(listener);
    }

    public static void registerWorldRenderAfterLevel(WorldRenderContextListener listener) {
        worldRenderAfterLevelListeners.add(listener);
    }
}

