/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.client.event.listener;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.pitan76.mcpitanlib.api.util.VoxelShapeUtil;
import org.jetbrains.annotations.Nullable;

public interface WorldRenderContext {
    public WorldRenderer getWorldRenderer();

    public MatrixStack getMatrixStack();

    public float getTickDelta();

    public ActiveRenderInfo getCamera();

    public GameRenderer getGameRenderer();

    public LightTexture getLightmapTextureManager();

    @Deprecated
    public Matrix4f getProjectionMatrix();

    public ClientWorld getWorld();

    @Deprecated
    public boolean isAdvancedTranslucency();

    @Nullable
    public IRenderTypeBuffer getConsumers();

    @Nullable
    public ClippingHelper getFrustum();

    default public RayTraceResult getHitResult() {
        return Minecraft.func_71410_x().field_71476_x;
    }

    default public Optional<BlockState> getBlockState() {
        return Optional.ofNullable(this.getWorld().func_180495_p((BlockPos)this.getBlockPos().orElse(null)));
    }

    default public Optional<BlockPos> getBlockPos() {
        return Optional.ofNullable(((BlockRayTraceResult)this.getHitResult()).func_216350_a());
    }

    default public boolean isBlockType() {
        return this.getHitResultType() == RayTraceResult.Type.BLOCK;
    }

    default public RayTraceResult.Type getHitResultType() {
        return this.getHitResult().func_216346_c();
    }

    default public Optional<VoxelShape> getOutlineShape() {
        return this.getBlockState().map(blockState -> blockState.func_196954_c((IBlockReader)this.getWorld(), (BlockPos)this.getBlockPos().orElse(null)));
    }

    default public void push() {
        this.getMatrixStack().func_227860_a_();
    }

    default public void translate(double x, double y, double z) {
        this.getMatrixStack().func_227861_a_(x, y, z);
    }

    default public void pop() {
        this.getMatrixStack().func_227865_b_();
    }

    default public Optional<IVertexBuilder> getVertexConsumer() {
        if (this.getConsumers() == null) {
            return Optional.empty();
        }
        return Optional.of(Objects.requireNonNull(this.getConsumers()).getBuffer(RenderType.func_228659_m_()));
    }

    default public void drawBox(float red, float green, float blue, float alpha) {
        Optional<VoxelShape> outlineShape = this.getOutlineShape();
        if (!outlineShape.isPresent()) {
            return;
        }
        this.drawBox(VoxelShapeUtil.getBoundingBox(outlineShape.get()), red, green, blue, alpha);
    }

    default public void drawBox(AxisAlignedBB box, float red, float green, float blue, float alpha) {
        Optional<IVertexBuilder> vertexConsumer = this.getVertexConsumer();
        if (!vertexConsumer.isPresent()) {
            return;
        }
        WorldRenderer.func_228430_a_((MatrixStack)this.getMatrixStack(), (IVertexBuilder)vertexConsumer.get(), (AxisAlignedBB)box, (float)red, (float)green, (float)blue, (float)alpha);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface BlockOutlineContext {
        @Deprecated
        public IVertexBuilder vertexConsumer();

        public Entity entity();

        public double cameraX();

        public double cameraY();

        public double cameraZ();

        public BlockPos blockPos();

        public BlockState blockState();
    }
}

