/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.client.option;

import java.util.Objects;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.text.ITextComponent;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;

public class CompatKeyBinding {
    private final KeyBinding keyBinding;

    public CompatKeyBinding(KeyBinding keyBinding) {
        this.keyBinding = keyBinding;
    }

    public CompatKeyBinding(String translationKey, int defaultKeyCode, CompatIdentifier category) {
        this.keyBinding = new KeyBinding(translationKey, defaultKeyCode, "key.category." + category.getNamespace() + "." + category.getPath());
    }

    public CompatKeyBinding(String translationKey, int defaultKeyCode) {
        String[] parts = translationKey.split("\\.");
        if (!Objects.equals(parts[0], "key") || parts.length != 3) {
            throw new IllegalArgumentException("Cannot infer category from translation key: " + translationKey);
        }
        CompatIdentifier category = CompatIdentifier.of(parts[1], "main");
        this.keyBinding = new KeyBinding(translationKey, defaultKeyCode, "key.category." + category.getNamespace() + "." + category.getPath());
    }

    public String getTranslationKey() {
        return this.keyBinding.func_197982_m();
    }

    public ITextComponent getBoundKeyLocalizedText() {
        return this.keyBinding.func_238171_j_();
    }

    public int getDefaultKeyCode() {
        return this.keyBinding.func_197977_i().func_197937_c();
    }

    public static CompatKeyBinding of(String translationKey, int defaultKeyCode, CompatIdentifier category) {
        return new CompatKeyBinding(translationKey, defaultKeyCode, category);
    }

    public static CompatKeyBinding of(String translationKey, int defaultKeyCode) {
        return new CompatKeyBinding(translationKey, defaultKeyCode);
    }

    public KeyBinding toMinecraft() {
        return this.keyBinding;
    }

    public KeyBinding getRaw() {
        return this.keyBinding;
    }
}

