/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.event.block;

import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.pitan76.mcpitanlib.api.event.BaseEvent;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.SoundEventUtil;
import net.pitan76.mcpitanlib.api.util.WorldUtil;

public class EntityCollisionEvent
extends BaseEvent {
    public BlockState state;
    public World world;
    public BlockPos pos;
    public Entity entity;

    public EntityCollisionEvent(BlockState state, World world, BlockPos pos, Entity entity) {
        this.state = state;
        this.world = world;
        this.pos = pos;
        this.entity = entity;
    }

    public boolean isClient() {
        return WorldUtil.isClient(this.world);
    }

    public BlockPos getEntityPos() {
        return this.entity.func_233580_cy_();
    }

    public BlockPos getBlockPos() {
        return this.pos;
    }

    public BlockState getState() {
        return this.state;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public World getWorld() {
        return this.world;
    }

    public void playSound(SoundEvent event, SoundCategory category, float volume, float pitch) {
        WorldUtil.playSound(this.world, null, this.entity.func_233580_cy_(), event, category, volume, pitch);
    }

    public void playSound(SoundEvent event, float volume, float pitch) {
        this.playSound(event, SoundCategory.BLOCKS, volume, pitch);
    }

    public void playSound(SoundEvent event) {
        this.playSound(event, 1.0f, 1.0f);
    }

    public void playSound(SoundEvent event, SoundCategory category) {
        this.playSound(event, category, 1.0f, 1.0f);
    }

    public void playSound(CompatIdentifier id, SoundCategory category, float volume, float pitch) {
        this.playSound(SoundEventUtil.getSoundEvent(id), category, volume, pitch);
    }

    public boolean hasPlayerEntity() {
        return this.entity instanceof PlayerEntity;
    }

    public Optional<PlayerEntity> getPlayerEntity() {
        if (!this.hasPlayerEntity()) {
            return Optional.empty();
        }
        return Optional.of((PlayerEntity)this.entity);
    }

    public TileEntity getBlockEntity() {
        return WorldUtil.getBlockEntity(this.getWorld(), this.getBlockPos());
    }
}

