/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.event.block;

import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.pitan76.mcpitanlib.api.event.BaseEvent;
import net.pitan76.mcpitanlib.api.event.block.ItemScattererUtil;
import net.pitan76.mcpitanlib.api.util.WorldUtil;
import net.pitan76.mcpitanlib.midohra.block.BlockState;
import net.pitan76.mcpitanlib.midohra.block.BlockWrapper;
import net.pitan76.mcpitanlib.midohra.block.entity.BlockEntityWrapper;
import net.pitan76.mcpitanlib.midohra.world.IWorldView;

public class StateReplacedEvent
extends BaseEvent {
    public net.minecraft.block.BlockState state;
    public World world;
    public BlockPos pos;
    public net.minecraft.block.BlockState newState;
    public boolean moved;

    public StateReplacedEvent(net.minecraft.block.BlockState state, World world, BlockPos pos, net.minecraft.block.BlockState newState, boolean moved) {
        this.state = state;
        this.world = world;
        this.pos = pos;
        this.newState = newState;
        this.moved = moved;
    }

    public net.minecraft.block.BlockState getState() {
        return this.state;
    }

    public World getWorld() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public net.minecraft.block.BlockState getNewState() {
        return this.newState;
    }

    public boolean isMoved() {
        return this.moved;
    }

    public boolean isClient() {
        return this.world.func_201670_d();
    }

    public boolean isSameState() {
        return this.state.func_203425_a(this.newState.func_177230_c());
    }

    public boolean hasBlockEntity() {
        return WorldUtil.hasBlockEntity(this.world, this.pos);
    }

    public TileEntity getBlockEntity() {
        return WorldUtil.getBlockEntity(this.world, this.pos);
    }

    public void spawnDropsInContainer() {
        if (this.isSameState() || !this.hasInventory()) {
            return;
        }
        ItemScattererUtil.spawn(this.getWorld(), this.getPos(), this.getBlockEntity());
        this.updateComparators();
    }

    public boolean hasInventory() {
        return this.getBlockEntity() instanceof IInventory;
    }

    public void updateComparators() {
        WorldUtil.updateComparators(this.getWorld(), this.getPos(), this.getState().func_177230_c());
    }

    public net.pitan76.mcpitanlib.midohra.world.World getMidohraWorld() {
        return net.pitan76.mcpitanlib.midohra.world.World.of(this.world);
    }

    public IWorldView getWorldView() {
        return this.getMidohraWorld();
    }

    public BlockState getMidohraState() {
        return BlockState.of(this.state);
    }

    public net.pitan76.mcpitanlib.midohra.util.math.BlockPos getMidohraPos() {
        return net.pitan76.mcpitanlib.midohra.util.math.BlockPos.of(this.pos);
    }

    public BlockWrapper getBlockWrapper() {
        return BlockWrapper.of(this.state.func_177230_c());
    }

    public BlockEntityWrapper getBlockEntityWrapper() {
        return BlockEntityWrapper.of(this.getBlockEntity());
    }
}

