/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.event.item;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.pitan76.mcpitanlib.api.event.BaseEvent;
import net.pitan76.mcpitanlib.api.util.WorldUtil;
import net.pitan76.mcpitanlib.api.util.entity.EquipmentSlotUtil;
import net.pitan76.mcpitanlib.api.util.entity.LivingEntityUtil;

public class InventoryTickEvent
extends BaseEvent {
    public ItemStack stack;
    public World world;
    public Entity entity;
    public int slot;
    public boolean selected;
    public EquipmentSlotType equipmentSlot;

    public InventoryTickEvent(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        this.stack = stack;
        this.world = world;
        this.entity = entity;
        this.slot = slot;
        this.selected = selected;
        this.equipmentSlot = EquipmentSlotUtil.fromEntitySlotId(slot);
    }

    public InventoryTickEvent(ItemStack stack, ServerWorld world, Entity entity, EquipmentSlotType slot) {
        this(stack, (World)world, entity, EquipmentSlotUtil.getEntitySlotId(slot), InventoryTickEvent.isSelected(entity, slot, stack));
        this.equipmentSlot = slot;
    }

    private static boolean isSelected(Entity entity, EquipmentSlotType slot, ItemStack stack) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            ItemStack equippedStack = LivingEntityUtil.getEquippedStack(livingEntity, slot);
            return equippedStack.func_77973_b().equals(stack.func_77973_b()) && equippedStack.func_190916_E() == stack.func_190916_E();
        }
        return false;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public World getWorld() {
        return this.world;
    }

    public boolean isServer() {
        return !this.isClient();
    }

    public ServerWorld getServerWorld() {
        return (ServerWorld)this.world;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public int getSlot() {
        return this.slot;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isClient() {
        return WorldUtil.isClient(this.world);
    }

    public EquipmentSlotType getEquipmentSlot() {
        return this.equipmentSlot;
    }
}

