/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.event.item;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.api.event.BaseEvent;
import net.pitan76.mcpitanlib.api.item.ArmorEquipmentType;
import net.pitan76.mcpitanlib.api.tag.TagKey;
import net.pitan76.mcpitanlib.api.util.BlockUtil;
import net.pitan76.mcpitanlib.api.util.WorldUtil;

public class PostMineEvent
extends BaseEvent {
    public ItemStack stack;
    public World world;
    public BlockState state;
    public BlockPos pos;
    public LivingEntity miner;

    public PostMineEvent(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity miner) {
        this.stack = stack;
        this.world = world;
        this.state = state;
        this.pos = pos;
        this.miner = miner;
    }

    public BlockState getState() {
        return this.state;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public World getWorld() {
        return this.world;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public LivingEntity getMiner() {
        return this.miner;
    }

    public TileEntity getBlockEntity() {
        return WorldUtil.getBlockEntity(this.world, this.pos);
    }

    public boolean isClient() {
        return this.world.field_72995_K;
    }

    public boolean stateIsIn(TagKey<Block> tagKey) {
        return BlockUtil.isIn(this.state.func_177230_c(), tagKey);
    }

    public boolean stateIsOf(Block block) {
        return BlockUtil.isEqual(this.state.func_177230_c(), block);
    }

    public void damageStack(int amount, EquipmentSlotType slot) {
        this.stack.func_222118_a(amount, this.miner, entity -> entity.func_213361_c(slot));
    }

    public void damageStack(int amount, ArmorEquipmentType type) {
        this.stack.func_222118_a(amount, this.miner, entity -> entity.func_213361_c(type.getSlot()));
    }

    public void damageStack(int amount) {
        this.stack.func_222118_a(amount, this.miner, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
    }

    public boolean isPlayer() {
        return this.miner instanceof PlayerEntity;
    }

    public Player getPlayer() {
        if (this.isPlayer()) {
            return new Player((PlayerEntity)this.miner);
        }
        return null;
    }

    public boolean isCreative() {
        return this.isPlayer() && this.getPlayer().isCreative();
    }

    public boolean isSneaking() {
        return this.miner.func_225608_bj_();
    }

    public ItemStack getMainHandStack() {
        return this.miner.func_184614_ca();
    }
}

