/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.event.v0;

import me.shedaniel.architectury.event.events.InteractionEvent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.api.event.result.EventResult;
import net.pitan76.mcpitanlib.api.event.v0.event.ClickBlockEvent;
import net.pitan76.mcpitanlib.api.util.CompatActionResult;
import net.pitan76.mcpitanlib.api.util.StackActionResult;

public class InteractionEventRegistry {
    public static void registerRightClickBlock(RightClickBlock rightClickBlock) {
        InteractionEvent.RIGHT_CLICK_BLOCK.register((player, hand, pos, direction) -> rightClickBlock.click(new ClickBlockEvent(player, hand, pos, direction)).toActionResult());
    }

    public static void registerLeftClickBlock(LeftClickBlock leftClickBlock) {
        InteractionEvent.LEFT_CLICK_BLOCK.register((player, hand, pos, direction) -> leftClickBlock.click(new ClickBlockEvent(player, hand, pos, direction)).toActionResult());
    }

    public static void registerRightClickItem(RightClickItem rightClickItem) {
        InteractionEvent.RIGHT_CLICK_ITEM.register(rightClickItem::click);
    }

    public static void registerClientLeftClickAir(ClientLeftClickAir clientLeftClickAir) {
        InteractionEvent.CLIENT_LEFT_CLICK_AIR.register(clientLeftClickAir::click);
    }

    public static void registerClientRightClickAir(ClientRightClickAir clientRightClickAir) {
        InteractionEvent.CLIENT_RIGHT_CLICK_AIR.register(clientRightClickAir::click);
    }

    public static void registerInteractEntity(InteractEntity interactEntity) {
        InteractionEvent.INTERACT_ENTITY.register(interactEntity::interact);
    }

    public static interface RightClickBlock {
        public EventResult click(ClickBlockEvent var1);
    }

    public static interface LeftClickBlock {
        public EventResult click(ClickBlockEvent var1);
    }

    public static interface RightClickItem {
        default public ActionResult<ItemStack> click(PlayerEntity var1, Hand var2) {
            CompatActionResult result = this.click(new Player(var1), var2);
            if (result instanceof StackActionResult) {
                return ((StackActionResult)result).toTypedActionResult();
            }
            ItemStack stack = var1.func_184586_b(var2);
            return StackActionResult.create(result, stack).toTypedActionResult();
        }

        public CompatActionResult click(Player var1, Hand var2);
    }

    public static interface ClientLeftClickAir {
        default public void click(PlayerEntity var1, Hand var2) {
            this.click(new Player(var1), var2);
        }

        public void click(Player var1, Hand var2);
    }

    public static interface ClientRightClickAir {
        default public void click(PlayerEntity var1, Hand var2) {
            this.click(new Player(var1), var2);
        }

        public void click(Player var1, Hand var2);
    }

    public static interface InteractEntity {
        default public ActionResultType interact(PlayerEntity var1, Entity var2, Hand var3) {
            return this.interact(new Player(var1), var2, var3).toActionResult();
        }

        public CompatActionResult interact(Player var1, Entity var2, Hand var3);
    }
}

