/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.event.v0.event;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.api.util.BlockStateUtil;
import net.pitan76.mcpitanlib.api.util.WorldUtil;

public class ClickBlockEvent {
    public Player player;
    public Hand hand;
    public BlockPos pos;
    public Direction direction;

    public ClickBlockEvent(Player player, Hand hand, BlockPos pos, Direction direction) {
        this.player = player;
        this.hand = hand;
        this.pos = pos;
        this.direction = direction;
    }

    public ClickBlockEvent(PlayerEntity player, Hand hand, BlockPos pos, Direction direction) {
        this.player = new Player(player);
        this.hand = hand;
        this.pos = pos;
        this.direction = direction;
    }

    public Player getPlayer() {
        return this.player;
    }

    public Hand getHand() {
        return this.hand;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public boolean isExistPlayer() {
        return this.player.getEntity() != null;
    }

    public ItemStack getStackInHand() {
        return this.player.getStackInHand(this.hand);
    }

    public boolean isEmptyStackInHand() {
        return this.getStackInHand().func_190926_b();
    }

    public World getWorld() {
        return this.player.getWorld();
    }

    public BlockState getBlockState() {
        return WorldUtil.getBlockState(this.getWorld(), this.getPos());
    }

    public Block getBlock() {
        return BlockStateUtil.getBlock(this.getBlockState());
    }
}

