/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.event.v1.event;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.util.Hand;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.world.World;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.midohra.item.ItemStack;
import net.pitan76.mcpitanlib.midohra.item.ItemWrapper;
import org.jetbrains.annotations.Nullable;

public class AttackEntityEvent {
    public Player player;
    public World world;
    public Entity target;
    public Hand hand;
    public EntityRayTraceResult result;

    public AttackEntityEvent(PlayerEntity player, World level, Entity target, Hand hand, @Nullable EntityRayTraceResult result) {
        this(new Player(player), level, target, hand, result);
    }

    public AttackEntityEvent(Player player, World level, Entity target, Hand hand, @Nullable EntityRayTraceResult result) {
        this.player = player;
        this.world = level;
        this.target = target;
        this.hand = hand;
        this.result = result;
    }

    public Player getPlayer() {
        return this.player;
    }

    public World getWorld() {
        return this.world;
    }

    public Entity getTarget() {
        return this.target;
    }

    public EntityRayTraceResult getResult() {
        return this.result;
    }

    public Hand getHand() {
        return this.hand;
    }

    public net.minecraft.item.ItemStack getStackInPlayer() {
        return this.player.getStackInHand(this.hand);
    }

    public Item getItemInPlayer() {
        return this.getStackInPlayer().func_77973_b();
    }

    public net.pitan76.mcpitanlib.midohra.world.World getWorldAsMidohra() {
        return net.pitan76.mcpitanlib.midohra.world.World.of(this.world);
    }

    public ItemStack getStackInPlayerAsMidohra() {
        return ItemStack.of(this.getStackInPlayer());
    }

    public ItemWrapper getItemWrapperInPlayer() {
        return ItemWrapper.of(this.getItemInPlayer());
    }
}

