/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.event.v2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.pitan76.mcpitanlib.api.event.v2.AbstractEvent;

public class OrderedEvent<T>
extends AbstractEvent<T> {
    public volatile Map<T, Integer> listeners = new HashMap<T, Integer>();
    public volatile int maxPriority = 0;

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public boolean isExists(T listener) {
        return this.listeners.containsKey(listener);
    }

    public boolean has(T listener) {
        return this.isExists(listener);
    }

    public boolean hasPriority(T listener) {
        if (!this.isExists(listener)) {
            return false;
        }
        return this.listeners.get(listener) != null && this.listeners.get(listener) != 0;
    }

    public void setPriority(T listener, int priority) {
        if (!this.isExists(listener)) {
            this.listeners.put(listener, priority);
            return;
        }
        this.listeners.replace(listener, priority);
    }

    public void register(T listener, int priority) {
        this.listeners.put(listener, priority);
        if (priority > this.maxPriority) {
            this.maxPriority = priority;
        }
    }

    @Override
    public void register(T listener) {
        if (this.isExists(listener)) {
            throw new IllegalArgumentException("Listener already exists");
        }
        this.listeners.put(listener, 0);
    }

    public void registerNonSafe(T listener) {
        if (this.isExists(listener)) {
            return;
        }
        this.register(listener);
    }

    @Override
    public void unregister(T listener) {
        if (!this.isExists(listener)) {
            return;
        }
        this.listeners.remove(listener);
    }

    @Override
    public List<T> getListenersAsList() {
        return new ArrayList<T>(this.listeners.keySet());
    }

    public int getPriority(T listener) {
        return this.listeners.get(listener);
    }

    public int getMaxPriority() {
        return this.maxPriority;
    }

    public int nextPriority() {
        return this.maxPriority + 1;
    }

    @Override
    @Deprecated
    public T getListener(int index) {
        return this.getListenersAsList().get(index);
    }

    public List<T> getListenersAsList(int priority) {
        ArrayList<T> listeners = new ArrayList<T>();
        for (Map.Entry<T, Integer> entry : this.listeners.entrySet()) {
            if (entry.getValue() != priority) continue;
            listeners.add(entry.getKey());
        }
        return listeners;
    }

    @Deprecated
    public T[] getListeners(int priority) {
        return this.getListenersAsList(priority).toArray();
    }

    public Map<T, Integer> getListeners() {
        return this.listeners;
    }
}

