/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.item;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Food;
import net.minecraft.potion.EffectInstance;
import net.pitan76.mcpitanlib.api.entity.effect.CompatStatusEffectInstance;

public class CompatFoodComponent {
    private int hunger;
    private float saturation;
    private boolean meat;
    private boolean alwaysEdible;
    private boolean snack;
    private final List<Pair<EffectInstance, Float>> statusEffects = new ArrayList<Pair<EffectInstance, Float>>();
    private Food latestComponent = null;

    public static CompatFoodComponent create() {
        return new CompatFoodComponent();
    }

    public CompatFoodComponent setHunger(int hunger) {
        this.hunger = hunger;
        return this;
    }

    public CompatFoodComponent setSaturation(float saturation) {
        this.saturation = saturation;
        return this;
    }

    public CompatFoodComponent setAlwaysEdible() {
        this.alwaysEdible = true;
        return this;
    }

    public CompatFoodComponent setSnack() {
        this.snack = true;
        return this;
    }

    public CompatFoodComponent setMeat() {
        this.meat = true;
        return this;
    }

    @Deprecated
    public CompatFoodComponent addStatusEffect(EffectInstance effect, float chance) {
        this.statusEffects.add((Pair<EffectInstance, Float>)Pair.of((Object)effect, (Object)Float.valueOf(chance)));
        return this;
    }

    public CompatFoodComponent addStatusEffect(CompatStatusEffectInstance instance, float chance) {
        return this.addStatusEffect(instance.getInstance(), chance);
    }

    public Food.Builder getVanillaBuilder() {
        Food.Builder builder = new Food.Builder();
        builder.func_221456_a(this.hunger).func_221454_a(this.saturation);
        if (this.alwaysEdible) {
            builder.func_221455_b();
        }
        if (this.snack) {
            builder.func_221457_c();
        }
        if (this.meat) {
            builder.func_221451_a();
        }
        for (Pair<EffectInstance, Float> pair : this.statusEffects) {
            builder.func_221452_a((EffectInstance)pair.getFirst(), ((Float)pair.getSecond()).floatValue());
        }
        return builder;
    }

    public Food build() {
        return this.vanillaBuild();
    }

    public Food vanillaBuild() {
        if (this.latestComponent != null) {
            return this.latestComponent;
        }
        this.latestComponent = this.getVanillaBuilder().func_221453_d();
        return this.latestComponent;
    }

    public int getHunger() {
        return this.hunger;
    }

    public float getSaturation() {
        return this.saturation;
    }

    public boolean isMeat() {
        return this.meat;
    }

    public boolean isSnack() {
        return this.snack;
    }

    public boolean isAlwaysEdible() {
        return this.alwaysEdible;
    }

    @Deprecated
    public List<Pair<EffectInstance, Float>> getStatusEffects() {
        return this.statusEffects;
    }

    public List<Pair<CompatStatusEffectInstance, Float>> getCompatStatusEffects() {
        ArrayList<Pair<CompatStatusEffectInstance, Float>> compatStatusEffects = new ArrayList<Pair<CompatStatusEffectInstance, Float>>();
        for (Pair<EffectInstance, Float> pair : this.statusEffects) {
            compatStatusEffects.add((Pair<CompatStatusEffectInstance, Float>)Pair.of((Object)new CompatStatusEffectInstance((EffectInstance)pair.getFirst()), (Object)((Float)pair.getSecond())));
        }
        return compatStatusEffects;
    }
}

