/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.network.v2;

import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.api.network.PacketByteUtil;
import net.pitan76.mcpitanlib.api.network.v2.args.ServerReceiveEvent;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.midohra.network.CompatPacketByteBuf;

public class ServerNetworking {
    public static void send(ServerPlayerEntity serverPlayerEntity, CompatIdentifier id, PacketBuffer buf) {
        net.pitan76.mcpitanlib.api.network.ServerNetworking.send(serverPlayerEntity, id.toMinecraft(), buf);
    }

    public static void sendByServerPlayerEntity(Iterable<ServerPlayerEntity> players, CompatIdentifier id, PacketBuffer buf) {
        net.pitan76.mcpitanlib.api.network.ServerNetworking.send(players, id.toMinecraft(), buf);
    }

    public static void send(Player player, CompatIdentifier id, PacketBuffer buf) {
        Optional<ServerPlayerEntity> optional = player.getServerPlayer();
        if (!optional.isPresent()) {
            return;
        }
        ServerNetworking.send(optional.get(), id, buf);
    }

    public static void send(Iterable<Player> players, CompatIdentifier id, PacketBuffer buf) {
        ArrayList<ServerPlayerEntity> list = new ArrayList<ServerPlayerEntity>();
        for (Player player : players) {
            Optional<ServerPlayerEntity> optional = player.getServerPlayer();
            optional.ifPresent(list::add);
        }
        ServerNetworking.sendByServerPlayerEntity(list, id, buf);
    }

    public static void sendAll(MinecraftServer server, CompatIdentifier id, PacketBuffer buf) {
        net.pitan76.mcpitanlib.api.network.ServerNetworking.sendAll(server, id.toMinecraft(), buf);
    }

    public static void sendAll(World world, CompatIdentifier id, PacketBuffer buf) {
        ServerNetworking.sendAll(world.func_73046_m(), id, buf);
    }

    public static void registerReceiver(CompatIdentifier id, Consumer<ServerReceiveEvent> consumer) {
        net.pitan76.mcpitanlib.api.network.ServerNetworking.registerReceiver(id.toMinecraft(), (MinecraftServer server, ServerPlayerEntity player, PacketBuffer buf) -> consumer.accept(new ServerReceiveEvent(server, player, buf)));
    }

    public static void send(ServerPlayerEntity serverPlayerEntity, CompatIdentifier id, CompatPacketByteBuf buf) {
        ServerNetworking.send(serverPlayerEntity, id, buf.getRaw());
    }

    public static void send(Player player, CompatIdentifier id, CompatPacketByteBuf buf) {
        ServerNetworking.send(player, id, buf.getRaw());
    }

    public static void send(Iterable<Player> players, CompatIdentifier id, CompatPacketByteBuf buf) {
        ServerNetworking.send(players, id, buf.getRaw());
    }

    public static void sendAll(MinecraftServer server, CompatIdentifier id, CompatPacketByteBuf buf) {
        ServerNetworking.sendAll(server, id, buf.getRaw());
    }

    public static void sendAll(World world, CompatIdentifier id, CompatPacketByteBuf buf) {
        ServerNetworking.sendAll(world.func_73046_m(), id, buf.getRaw());
    }

    public static void send(ServerPlayerEntity serverPlayerEntity, CompatIdentifier id) {
        ServerNetworking.send(serverPlayerEntity, id, PacketByteUtil.create());
    }

    public static void send(Player player, CompatIdentifier id) {
        ServerNetworking.send(player, id, PacketByteUtil.create());
    }

    public static void send(Iterable<Player> players, CompatIdentifier id) {
        ServerNetworking.send(players, id, PacketByteUtil.create());
    }

    public static void sendAll(MinecraftServer server, CompatIdentifier id) {
        ServerNetworking.sendAll(server, id, PacketByteUtil.create());
    }

    public static void sendAll(World world, CompatIdentifier id) {
        ServerNetworking.sendAll(world.func_73046_m(), id, PacketByteUtil.create());
    }
}

