/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.registry;

import java.util.function.Supplier;
import me.shedaniel.architectury.registry.RegistrySupplier;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.pitan76.mcpitanlib.MCPitanLib;
import net.pitan76.mcpitanlib.api.block.CompatibleMaterial;
import net.pitan76.mcpitanlib.api.block.v2.CompatibleBlockSettings;
import net.pitan76.mcpitanlib.api.gui.ExtendedScreenHandlerTypeBuilder;
import net.pitan76.mcpitanlib.api.item.CreativeTabBuilder;
import net.pitan76.mcpitanlib.api.item.CreativeTabManager;
import net.pitan76.mcpitanlib.api.item.v2.CompatibleItemSettings;
import net.pitan76.mcpitanlib.api.registry.WorldGenRegistry;
import net.pitan76.mcpitanlib.api.registry.result.RegistryResult;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.block.BlockUtil;
import net.pitan76.mcpitanlib.api.util.item.ItemUtil;
import net.pitan76.mcpitanlib.core.registry.FuelRegistry;
import net.pitan76.mcpitanlib.core.registry.MCPLRegistry;
import net.pitan76.mcpitanlib.core.registry.MCPLRegistry1_20;

public class CompatRegistry {
    protected final MCPLRegistry mcplr;
    protected final MCPLRegistry1_20 mcplr1_20;
    protected final WorldGenRegistry worldGenRegistry;
    protected String MOD_ID;

    @Deprecated
    public CompatRegistry(String MOD_ID) {
        this.mcplr = new MCPLRegistry(MOD_ID);
        this.mcplr1_20 = new MCPLRegistry1_20(this.mcplr, MOD_ID);
        this.worldGenRegistry = new WorldGenRegistry(MOD_ID);
        this.MOD_ID = MOD_ID;
    }

    public static CompatRegistry createRegistry(String MOD_ID) {
        return new CompatRegistry(MOD_ID);
    }

    public static CompatRegistry create(String MOD_ID) {
        return CompatRegistry.createRegistry(MOD_ID);
    }

    public RegistryResult<Item> registerItem(ResourceLocation id, Supplier<Item> supplier) {
        if (MCPitanLib.isItemBlackListed(id)) {
            supplier = () -> ItemUtil.create(CompatibleItemSettings.of(CompatIdentifier.fromMinecraft(id)));
        }
        RegistrySupplier<Item> registrySupplier = this.mcplr.registryItem(id, supplier);
        CreativeTabManager.register(id);
        return new RegistryResult<Item>(registrySupplier);
    }

    public RegistryResult<Block> registerBlock(ResourceLocation id, Supplier<Block> supplier) {
        if (MCPitanLib.isBlockBlackListed(id)) {
            supplier = () -> BlockUtil.create(CompatibleBlockSettings.of(CompatIdentifier.fromMinecraft(id), CompatibleMaterial.STONE));
        }
        return new RegistryResult<Block>(this.mcplr.registryBlock(id, supplier));
    }

    public RegistryResult<ContainerType<?>> registerScreenHandlerType(ResourceLocation id, Supplier<ContainerType<?>> supplier) {
        return new RegistryResult(this.mcplr.registryScreenHandlerType(id, supplier));
    }

    @Deprecated
    public RegistryResult<ContainerType<?>> registerExtendedScreenHandlerType(ResourceLocation id, Supplier<ExtendedScreenHandlerTypeBuilder<?>> supplier) {
        return this.registerScreenHandlerType(id, () -> ((ExtendedScreenHandlerTypeBuilder)supplier.get()).build());
    }

    public RegistryResult<ContainerType<?>> registerMenu(ResourceLocation id, Supplier<ContainerType<?>> supplier) {
        return this.registerScreenHandlerType(id, supplier);
    }

    public RegistryResult<TileEntityType<?>> registerBlockEntityType(ResourceLocation id, Supplier<TileEntityType<?>> supplier) {
        return new RegistryResult(this.mcplr.registryBlockEntityType(id, supplier));
    }

    public RegistryResult<EntityType<?>> registerEntity(ResourceLocation id, Supplier<EntityType<?>> supplier) {
        return new RegistryResult(this.mcplr.registryEntityType(id, supplier));
    }

    @Deprecated
    public RegistryResult<SoundEvent> registerSoundEvent(ResourceLocation id, Supplier<SoundEvent> supplier) {
        return new RegistryResult<SoundEvent>(this.mcplr.registrySoundEvent(id, supplier));
    }

    public RegistryResult<SoundEvent> registerSoundEvent(ResourceLocation id) {
        return this.registerSoundEvent(id, () -> new SoundEvent(id));
    }

    public RegistryResult<SoundEvent> registerSoundEvent(ResourceLocation id, float distanceToTravel) {
        return this.registerSoundEvent(id, () -> new SoundEvent(id));
    }

    public RegistryResult<Fluid> registerFluid(ResourceLocation id, Supplier<Fluid> supplier) {
        return new RegistryResult<Fluid>(this.mcplr.registryFluid(id, supplier));
    }

    public RegistryResult<ParticleType<?>> registerParticleType(ResourceLocation id, Supplier<ParticleType<?>> supplier) {
        return new RegistryResult(this.mcplr.registryParticleType(id, supplier));
    }

    public RegistryResult<Enchantment> registerEnchantment(ResourceLocation id, Supplier<Enchantment> supplier) {
        return new RegistryResult<Enchantment>(this.mcplr.registryEnchantment(id, supplier));
    }

    public RegistryResult<Effect> registerStatusEffect(ResourceLocation id, Supplier<Effect> supplier) {
        return new RegistryResult<Effect>(this.mcplr.registryStatusEffect(id, supplier));
    }

    public RegistryResult<ItemGroup> registerItemGroup(ResourceLocation id, Supplier<ItemGroup> supplier) {
        return new RegistryResult<ItemGroup>(null);
    }

    public RegistryResult<ItemGroup> registerItemGroup(ResourceLocation id, CreativeTabBuilder builder) {
        return new RegistryResult<ItemGroup>(this.mcplr1_20.registryItemGroup(id, builder));
    }

    public RegistryResult<ItemGroup> registerItemGroup(CreativeTabBuilder builder) {
        return this.registerItemGroup(builder.getIdentifier(), builder);
    }

    public static void registerFuel(int time, IItemProvider ... item) {
        FuelRegistry.register(time, item);
    }

    public void allRegister() {
        this.mcplr.allRegister1_16();
        this.mcplr1_20.register();
        CreativeTabManager.allRegister();
    }

    @Deprecated
    public MCPLRegistry getMcplr() {
        return this.mcplr;
    }

    @Deprecated
    public MCPLRegistry1_20 getMcplr1_20() {
        return this.mcplr1_20;
    }

    public String getNamespace() {
        return this.MOD_ID;
    }
}

