/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.text;

import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.pitan76.mcpitanlib.api.text.VariableTextComponent;
import net.pitan76.mcpitanlib.api.util.TextUtil;
import org.jetbrains.annotations.Nullable;

public class TextComponent {
    private ITextComponent text;

    public TextComponent() {
        this((ITextComponent)TextUtil.empty());
    }

    public TextComponent(ITextComponent text) {
        this.text = text;
    }

    public TextComponent(String string) {
        this((ITextComponent)TextUtil.literal(string));
    }

    public ITextComponent getText() {
        return this.text;
    }

    public void setText(ITextComponent text) {
        this.text = text;
    }

    public IFormattableTextComponent asMutableText() {
        return (IFormattableTextComponent)this.text;
    }

    public VariableTextComponent asVariableTextComponent() {
        return new VariableTextComponent(this);
    }

    @Nullable
    public IFormattableTextComponent asMutableTextOrNull() {
        if (this.text instanceof IFormattableTextComponent) {
            return this.asMutableText();
        }
        return null;
    }

    public static TextComponent literal(String string) {
        return new TextComponent(string);
    }

    public static TextComponent of(String string) {
        return TextComponent.literal(string);
    }

    public static TextComponent translatable(String key) {
        return new TextComponent((ITextComponent)TextUtil.translatable(key));
    }

    public static TextComponent translatable(String key, Object ... args) {
        return new TextComponent((ITextComponent)TextUtil.translatable(key, args));
    }

    public String toString() {
        return this.getString();
    }

    public String getString() {
        return TextUtil.txt2str(this.getText());
    }

    public String superToString() {
        return super.toString();
    }

    public TextComponent copy() {
        return new TextComponent(this.getText());
    }

    public Style getStyle() {
        return this.text.func_150256_b();
    }

    public TextComponent setStyle(Style style) {
        if (this.text instanceof IFormattableTextComponent) {
            TextUtil.setStyle((IFormattableTextComponent)this.text, style);
        }
        return this;
    }

    public static TextComponent convert(String text) {
        return new TextComponent((ITextComponent)TextUtil.convert(text));
    }

    public static TextComponent convertWithTranslatable(String text) {
        return new TextComponent((ITextComponent)TextUtil.convertWithTranslatable(text));
    }
}

